<?php

namespace AcademyProStoreEngine;

use Academy\Interfaces\AddonInterface;
use AcademyProStoreEngine\Ajax\TutorBooking;
use AcademyProStoreEngine\Integrations\TutorIntegration;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

final class Storeengine implements AddonInterface {

	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public function define_constants() {
		define( 'ACADEMY_PRO_STOREENGINE_VERSION', '1.0' );
	}

	public function init_addon() {
		// stop if storeengine is not active
		if ( ! class_exists( \StoreEngine::class ) || ( defined( 'STOREENGINE_VERSION' ) && version_compare( STOREENGINE_VERSION, '1.0.0-beta-3', '<=' ) ) ) {
			return;
		}

		// initialize the addon functionality
		Hooks::init();
		Ajax::init();
	}

	public static function init(): self {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function addon_activation_hook() {
	}
}
