<?php
namespace  AcademyProSocialLogin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Shortcode {

	public function __construct() {
		add_shortcode( 'academy_social_login', array( $this, 'social_login' ) );
		add_action( 'academy/templates/shortcode/after_login', array( $this, 'add_social_login' ) );
	}

	public function social_login( $atts ) {
		$attributes = shortcode_atts(array(
			'is_register' => false,
			'role' => 'academy_student',
			'show_divider' => true,
		), $atts);

		$is_enabled_facebook_login = \Academy\Helper::get_settings( 'is_enabled_facebook_login' );
		$is_enabled_google_login = \Academy\Helper::get_settings( 'is_enabled_google_login' );

		ob_start();
		do_action( 'academy_pro_social_login/shortcode/before_dispatch' );
		\AcademyPro\Helper::get_template(
			'shortcode/social-login.php',
			array(
				'is_register' => (bool) $attributes['is_register'],
				'role' => $attributes['role'],
				'is_enabled_facebook_login' => $is_enabled_facebook_login,
				'is_enabled_google_login' => $is_enabled_google_login,
				'show_divider' => (bool) $attributes['show_divider'],
			)
		);

		return apply_filters( 'academy_pro/templates/shortcode/social_login', ob_get_clean() );
	}

	public function add_social_login() {
		echo do_shortcode( '[academy_social_login]' );
	}
}
