<?php
namespace AcademyProSocialLogin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Assets {

	public static function init() {
		$self = new self();
		add_action( 'academy_pro_social_login/shortcode/before_dispatch', [ $self, 'enqueue_social_login_script' ], 30 );
		add_action( 'academy/templates/single_course_enroll_content', [ $self, 'enqueue_social_login_script' ], 30 );
	}
	public function enqueue_social_login_script() {
		$dependencies = include_once ACADEMY_PRO_ASSETS_DIR_PATH . sprintf( 'build/socialLogin.%s.asset.php', ACADEMY_PRO_VERSION );
		$is_enabled_google_login = \Academy\Helper::get_settings( 'is_enabled_google_login' );
		if ( true === $is_enabled_google_login ) {
			wp_enqueue_script(
				'academy-pro-social-gsi-client-api',
				'https://accounts.google.com/gsi/client',
				$dependencies['dependencies'],
				$dependencies['version'],
				true
			);
		}
		wp_enqueue_script(
			'academy-pro-social-login',
			ACADEMY_PRO_ASSETS_URI . sprintf( 'build/socialLogin.%s.js', ACADEMY_PRO_VERSION ),
			array_merge( $dependencies['dependencies'] ?? [], [ 'academy-common-scripts' ] ),
			$dependencies['version'] ?? [],
			true
		);
		wp_localize_script( 'academy-pro-social-login', 'AcademyProSocialLoginGlobal', [
			'facebook_app_id' => \Academy\Helper::get_settings( 'facebook_app_id' ),
			'facebook_app_secret' => \Academy\Helper::get_settings( 'facebook_app_secret' ),
		] );
	}

}
