<?php
namespace AcademyProSocialLogin\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Admin\Settings\Base as BaseSettings;
use Academy\Classes\Sanitizer;

class Settings {
	public static function init() {
		$self = new self();
		add_action( 'academy/admin/after_save_settings', array( $self, 'save_base_settings' ), 10, 3 );
		add_filter( 'academy/admin/settings/base_default_data', array( $self, 'settings_default_data' ) );
	}

	public function save_base_settings( $status, $settings_mode, $POST ) {
		$payload = Sanitizer::sanitize_payload([
			'is_enabled_facebook_login'       => 'boolean',
			'facebook_app_id'                 => 'string',
			'facebook_app_secret'             => 'string',
			// Google Login
			'is_enabled_google_login'         => 'boolean',
			'google_client_id'                => 'string',
		], $POST);

		$default = BaseSettings::get_default_data();

		$is_update = BaseSettings::save_settings( [
			'is_enabled_facebook_login'       => $payload['is_enabled_facebook_login'] ?? $default['is_enabled_facebook_login'],
			'facebook_app_id'                 => $payload['facebook_app_id'] ?? $default['facebook_app_id'],
			'facebook_app_secret'             => $payload['facebook_app_secret'] ?? $default['facebook_app_secret'],
			'is_enabled_google_login'         => $payload['is_enabled_google_login'] ?? $default['is_enabled_google_login'],
			'google_client_id'                => $payload['google_client_id'] ?? $default['google_client_id'],
		]);

		do_action( 'academy_pro/admin/after_save_settings', $is_update, 'base', $POST );
		return $is_update;
	}

	public function settings_default_data( $default_settings ) {
		// Facebook Login
		$default_settings['is_enabled_facebook_login'] = false;
		$default_settings['facebook_app_id'] = '';
		$default_settings['facebook_app_secret'] = '';
		// Google Login
		$default_settings['is_enabled_google_login'] = false;
		$default_settings['google_client_id'] = '';
		return $default_settings;
	}
}
