<?php
namespace AcademyProSendfox;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings {
	public static function init() {
		$self = new self();
		// sendfox settings
		add_action( 'academy/admin/settings/base_default_data', array( $self, 'get_sendfox_default_settings_data' ) );
		add_filter( 'academy/admin/settings/sanitize_payload', array( $self, 'sanitize_sendfox_default_settings' ) );
		add_filter( 'academy/admin/settings/save', array( $self, 'save_sendfox_settings_data' ), 11, 3 );
	}

	public function get_sendfox_default_settings_data( $default_data ) {
		return array_merge(
			$default_data,
			array(
				'sendfox_trigger_lists' => wp_json_encode(
					array(
						'student_enrolled_sendfox_list_id' => 0
					)
				),
			)
		);
	}

	public function sanitize_sendfox_default_settings( $sanitize_data ) {
		return array_merge(
			$sanitize_data,
			array(
				'sendfox_trigger_lists' => 'object'
			)
		);
	}

	public function save_sendfox_settings_data( $data, $payload, $default ) {
		$list_id = json_decode( $payload['sendfox_trigger_lists'] )->student_enrolled_sendfox_list_id ?? json_decode( $default['sendfox_trigger_lists'] )->student_enrolled_sendfox_list_id;
		return array_merge( $data,
			array(
				'sendfox_trigger_lists' => [
					'student_enrolled_sendfox_list_id' => $list_id,
				]
			)
		);
	}
}
