<?php
namespace AcademyProScorm;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use AcademyProScorm\ProgressTracker;

class Hooks {
	public static function init() {
		$self = new self();
		// add_action( 'rest_api_init', array( $self, 'course_progress_endpoint' ) );
		add_filter( 'academy/assets/frontend_scripts_data', array( $self, 'set_scorm_data' ) );
		add_filter( 'academy/get_course_curriculums', array( $self, 'update_course_curriculums' ), 10, 2 );
		add_filter( 'academy/single/is_show_complete_form', array( $self, 'is_show_complete_form' ), 10, 3 );
	}

	public function get_scorm_file_url( $file_name ) {
		$upload_dir = wp_get_upload_dir();
		return trailingslashit( $upload_dir['baseurl'] ) . 'academy_uploads/' . $file_name;
	}

	public function get_scorm_file_path( $file_name ) {
		return ABSPATH . 'wp-content/uploads/academy_uploads/' . $file_name; // Replace with the actual path to your file
	}

	public function get_scorm_manifest( $path ) {
		$manifest_path = "{$path}/imsmanifest.xml";
		return ( file_exists( $manifest_path ) ) ? $manifest_path : false;
	}

	public function get_scorm_version( $scorm_file ) {
		$scorm_version = '1.2';
		if ( $scorm_file ) {
			$manifest = $this->get_scorm_manifest( $this->get_scorm_file_path( $scorm_file ) );
			if ( $manifest ) {
				$xml_file      = simplexml_load_file( $manifest );
				$scorm_version = '1.2';
				if ( ! empty( $xml_file->metadata ) && count( $xml_file->metadata ) >= 1 ) {
					$schema_version = $xml_file->metadata[0]->schemaversion;
					if ( ! empty( $schema_version ) && '1.2' != $schema_version ) { // phpcs:ignore WordPress.PHP.StrictComparisons.LooseComparison
						$scorm_version = '2004';
					}
				} elseif ( ! empty( $xml_file['version'] ) ) {
					$scorm_version = (string) $xml_file['version'];
				}
				return $scorm_version;
			}
			return $scorm_version;
		}
		return $scorm_version;
	}

	public function get_scorm_iframe_url( $scorm_file ) {
		if ( $scorm_file ) {
			$scorm_file_url = $this->get_scorm_file_url( $scorm_file );
			$manifest = $this->get_scorm_manifest( $this->get_scorm_file_path( $scorm_file ) );
			if ( $manifest ) {
				$manifest      = simplexml_load_file( $manifest );
				if ( ! empty( $manifest )
					&& ! empty( $manifest->resources )
					&& ! empty( $manifest->resources->resource )
					&& ! empty( $manifest->resources->resource->attributes() )
				) {
					$atts = $manifest->resources->resource->attributes();
					if ( ! empty( $atts->href ) ) {
						return (string) $scorm_file_url . '/' . $atts->href;
					}
				}
			}
			return false;
		}
		return false;
	}

	public function set_scorm_data( $script_data ) {
		if ( is_singular( 'academy_courses' ) ) {
			$scorm_path = get_post_meta( get_the_ID(), '_academy_course_builder_scorm_file', true );
			$iframe_url = $this->get_scorm_iframe_url( $scorm_path );
			$version = $this->get_scorm_version( $scorm_path );
			$script_data['scrom_data'] = array(
				'url'       => $iframe_url,
				'version'   => $version
			);
		}
		return $script_data;
	}
	public function update_course_curriculums( $curriculums, $course_id ) {
		$scorm_path = get_post_meta( $course_id, '_academy_course_builder_scorm_file', true );
		if ( $scorm_path ) {
			return [];
		}
		return $curriculums;
	}
	public function is_show_complete_form( $is_show, $is_complete, $course_id ) {
		if ( ! $is_complete ) {
			$scorm_path = get_post_meta( $course_id, '_academy_course_builder_scorm_file', true );
			if ( ! $scorm_path ) {
				return $is_show;
			}
			$data           = ( new ProgressTracker() )->get_data( $course_id );
			$lesson_values  = explode( ',', $data['lessons'] ?? '' );

			$total_topics     = count( array_filter( $lesson_values, fn( $v ) => in_array( $v, [ '0', '1' ], true ) ) );
			$completed_topics = count( array_filter( $lesson_values, fn( $v ) => '1' === $v ) );

			if ( $total_topics === $completed_topics ) {
				return $is_show;
			}
			return false;
		}
		return $is_show;
	}
}
