<?php
namespace AcademyProRestrictContentPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Integration {
	public static function init() {
		$self = new self();
		add_filter( 'academy/templates/single_course/enroll_form', array( $self, 'rcp_modify_enrollment_form' ), 10, 2 );
		add_filter( 'academy/before_enroll_course_type', array( $self, 'change_course_type_before_enrollment' ), 10, 2 );
		add_filter( 'academy/templates/start_course_url', array( $self, 'handle_subscription_of_membership' ), 10, 2 );
		add_filter( 'academy/templates/loop/price', array( $self, 'modify_loop_price_args' ), 10, 2 );
		add_filter( 'academy/single/enroll_content_args', array( $self, 'modify_enroll_form_content_args' ), 10, 2 );
		add_filter( 'academy/get_course_filter_types', array( $self, 'add_course_membership_filter' ) );
	}

	public function rcp_modify_enrollment_form( $html, $course_id ) {
		$course_type = \Academy\Helper::get_course_type( $course_id );

		if ( 'rcp_membership' !== $course_type ) {
			return $html;
		}

		$is_enrolled = \Academy\Helper::is_enrolled( $course_id, get_current_user_id() );

		if ( $is_enrolled || Helper::has_course_access( $course_id ) ) {
			return $html;
		}
		$is_level_reached = false;
		$is_inactive = false;
		$membership_level_ids = Helper::get_current_course_memberships( $course_id );
		foreach ( $membership_level_ids as $membership_level_id ) {
			if ( Helper::is_inactive_in_membership_levels( $membership_level_id ) ) {
				$is_inactive = true;
			}

			$user_level = Helper::get_customer_membership_levels( $membership_level_id );
			if ( (int) $user_level->get_access_level() !== 0 ) {
				$active_subscribers = Helper::get_active_subscribers_by_membership_id( $membership_level_id );

				if ( $user_level <= $active_subscribers ) {
					$is_level_reached = true;
				}
			}
		}

		$is_enabled_academy_login = \Academy\Helper::get_settings( 'is_enabled_academy_login', true );
		ob_start();
		\AcademyPro\Helper::get_template( 'restrict-content-pro/restrict-message.php', [
			'is_enable_academy_login' => $is_enabled_academy_login,
			'is_level_reached' => $is_level_reached,
			'is_inactive_membership' => $is_inactive,
		] );

		return ob_get_clean();
	}

	public function change_course_type_before_enrollment( $course_type, $course_id ) {
		if ( 'rcp_membership' === $course_type && Helper::has_course_access( $course_id ) ) {
			return 'free';
		}

		return $course_type;
	}

	public function handle_subscription_of_membership( $permalink, $course_id ) {
		$course_type = get_post_meta( $course_id, 'academy_course_type', true );
		$is_administrator = current_user_can( 'administrator' );
		$is_instructor    = \Academy\Helper::is_instructor_of_this_course( get_current_user_id(), $course_id );

		if ( 'rcp_membership' !== $course_type || $is_administrator || $is_instructor ) {
			return $permalink;
		}

		if ( ! Helper::has_course_access( $course_id ) ) {
			\Academy\Helper::cancel_course_enroll( $course_id, get_current_user_id() );
			return $permalink;
		}

		return $permalink;
	}

	public function modify_loop_price_args( $course_type, $course_id ) {
		$type = get_post_meta( $course_id, 'academy_course_type', true );
		if ( 'rcp_membership' === $type ) {
			$course_type = esc_html__( 'Membership', 'academy-pro' );
		}
		return $course_type;
	}

	public function modify_enroll_form_content_args( $args, $course_id ) {
		if ( 'rcp_membership' === get_post_meta( $course_id, 'academy_course_type', true ) ) {
			$args['is_paid'] = true;
			$args['price'] = '<div class="academy-course-type">' . __( 'Membership', 'academy-pro' ) . '</div>';
		}
		return $args;
	}

	public function add_course_membership_filter( $types ) {
		$types['rcp_membership'] = __( 'Membership', 'academy-pro' );
		return $types;
	}

}
