<?php
namespace AcademyProNotifications;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use  AcademyProNotifications\Admin\Settings;

class Hooks {
	private $settings = [
		'instructor_registration' => 'is_enabled_new_instructor_registration_onsite',
		'instructor_approval'     => 'is_enabled_new_instructor_approve_onsite',
		'instructor_remove'       => 'is_enabled_new_instructor_remove_onsite',
		'course_enrollment'       => 'is_enabled_new_course_enrollment_onsite',
		'cancel_enrollment'       => 'is_enabled_cancel_enrollment_onsite',
		'announcement_publish'    => 'is_enabled_announcement_publish_onsite',
		'student_registration'    => 'is_enabled_new_student_registration_onsite',
		'course_publish'          => 'is_enabled_new_course_publish_onsite',
		'course_complete'         => 'is_enabled_course_complete_onsite',
		'course_review'           => 'is_enabled_course_review_onsite',
		'quiz_submit'             => 'is_enabled_quiz_submit_onsite',
		'quiz_evaluate'           => 'is_enabled_quiz_evaluate_onsite',
		'assignment_submit'       => 'is_enabled_assignment_submit_onsite',
		'assignment_evaluate'     => 'is_enabled_assignment_evaluate_onsite',
		'withdraw_request_approved' => 'is_enabled_withdraw_request_approved_onsite',
		'withdraw_request_rejected' => 'is_enabled_withdraw_request_rejected_onsite',
		'question_answer_submit'  => 'is_enabled_question_answer_submit_onsite',
		'question_answer_reply'   => 'is_enabled_question_answer_reply_onsite',
	];
	public static function init() {
		$self = new self();
		add_filter( 'academy/api/settings/get_settings', array( $self, 'add_settings' ) );

		add_action( 'academy/admin/update_instructor_status', array( $self, 'instructor_approval_or_remove_onsite' ), 10, 2 );
		add_action( 'academy/course/after_enroll', array( $self, 'after_enroll_new_course_onsite' ), 10, 3 );
		add_action( 'academy_pro_enrollment/course/after_cancel_enroll', array( $self, 'after_cancel_enroll_onsite' ), 10, 3 );
		add_action( 'rest_after_insert_academy_announcement', array( $self, 'after_academy_announcement_onsite' ) );
		add_action( 'academy/shortcode/after_instructor_registration', array( $self, 'after_instructor_registration_onsite' ) );
		add_action( 'academy/admin/after_register_instructor', array( $self, 'after_instructor_registration_onsite' ) );
		add_action( 'academy/admin/after_register_student', array( $self, 'after_student_registration_onsite' ) );
		add_action( 'academy/shortcode/before_student_registration', array( $self, 'after_student_registration_onsite' ) );
		add_action( 'transition_post_status', array( $self, 'after_academy_course_publish_onsite' ), 10, 3 );
		add_action( 'academy/admin/course_complete_after', array( $self, 'after_course_complete_onsite' ), 10, 2 );
		add_action( 'academy/templates/review_after_comment_text', array( $self, 'after_new_course_review_onsite' ) );
		add_action( 'academy_quizzes/after_quiz_insert', array( $self, 'after_quiz_submit_onsite' ) );
		add_action( 'academy_quizzes/after_quiz_attempt_manual_review', array( $self, 'after_quiz_attempt_manual_review_onsite' ) );
		add_action( 'academy_pro/frontend/submitted_assignment', array( $self, 'after_assignment_submit_onsite' ) );
		add_action( 'academy_pro/frontend/after_evaluate_assignment', array( $self, 'after_assignment_evaluate_onsite' ) );
		add_action( 'academy/multi_instructor/withdraw_request_approved', array( $self, 'after_withdraw_request_updated_onsite' ) );
		add_action( 'academy/multi_instructor/withdraw_request_rejected', array( $self, 'after_withdraw_request_updated_onsite' ) );
		add_action( 'academy/frontend/insert_course_qa', array( $self, 'course_question_answer_insert_onsite' ) );
		add_action( 'academy/frontend/insert_course_qa_answered', array( $self, 'course_question_answer_reply_onsite' ) );
	}
	public function add_settings( $settings ) {
		if ( ! isset( $settings['notifications'] ) ) {
			$settings['notifications'] = Settings::get_saved_data();
		}
		return $settings;
	}

	public function instructor_approval_or_remove_onsite( $ID, $status ) {
		$isApproved = ( 'approved' === $status && Helper::get_setting( $this->settings['instructor_approval'] ) );
		$isRemoved = ( 'remove' === $status && Helper::get_setting( $this->settings['instructor_remove'] ) );

		if ( $isApproved || $isRemoved ) {
			$name = \Academy\Helper::get_instructor( $ID )->display_name;
			/* translators: %s is a username, %s is a username. */
			$content = $isApproved ? sprintf( __( 'Congratulations, %s! You are become an instructor now.', 'academy-pro' ), $name ) : sprintf( __( 'Alas, %s! You are removed from instructor.', 'academy-pro' ), $name );
			$status = $isApproved ? __( 'Approval', 'academy-pro' ) : __( 'Removed', 'academy-pro' );
			Helper::insert_notification_details(
				array(
					/* translators: %s is a username */
					'title' => sprintf( __( 'Instructor %s', 'academy-pro' ), $status ),
					'content' => $content,
					'status' => 'UNREAD',
					'receiver_id' => $ID,
					'post_id'  => 0,
					'topic_id' => 0,
					'type' => 'user-dashboard',
					'created_at' => current_time( 'mysql' ),
				)
			);
		}
	}

	public function after_enroll_new_course_onsite( $course_id, $enroll_id, $user_id ) {

		if (
			! Helper::is_enrollment_completed( $course_id, $user_id ) ||
			Helper::is_duplicate( $course_id, $user_id ) ||
			! Helper::get_setting( $this->settings['course_enrollment'] )
		) {
			return;
		}
		$enrolled_post = get_post( $enroll_id );
		$name          = get_userdata( $user_id )->display_name;
		$course_title  = get_the_title( $course_id );
		/* translators: %s is a username, %s is a coursename. */
		$body          = sprintf( __( 'Hey, %1$s! You have successfully enrolled the course %2$s .', 'academy-pro' ), $name, $course_title );
		Helper::insert_notification_details( array(
			'title' => __( 'Successfully Enrolled', 'academy-pro' ),
			'content' => $body,
			'status' => 'UNREAD',
			'receiver_id' => $user_id,
			'post_id'  => $course_id,
			'topic_id' => 0,
			'type' => 'academy_courses',
			'created_at' => $enrolled_post->post_date,
		) );
	}

	public function after_cancel_enroll_onsite( $course_id, $enroll_id, $user_id ) {
		if ( \Academy\Helper::is_enrolled( $course_id, $user_id ) || ! Helper::get_setting( $this->settings['cancel_enrollment'] ) ) {
			return;
		}

		$name         = get_userdata( $user_id )->display_name;
		$course_title = get_the_title( $course_id );
		/* translators: %s is a username, %s is a coursename. */
		$body         = sprintf( __( 'Alas, %1$s! You enrollment has been removed from the course %2$s .', 'academy-pro' ), $name, $course_title );
		Helper::insert_notification_details( array(
			'title' => 'Cancel Enrolled',
			'content' => $body,
			'status' => 'UNREAD',
			'receiver_id' => $user_id,
			'post_id'  => $course_id,
			'topic_id' => 0,
			'type' => 'academy_courses',
			'created_at' => current_time( 'mysql' ),
		) );
	}

	public function after_academy_announcement_onsite( $announcement ) {
		if ( ! Helper::get_setting( $this->settings['announcement_publish'] ) ) {
			return;
		}

		$announcement_course = get_post_meta( $announcement->ID, 'academy_announcements_course_ids', true );
		if ( ! count( $announcement_course ) ) {
			return;
		}
		$announcement_course = current( maybe_unserialize( $announcement_course ) );
		$course_id = $announcement_course['value'];
		$student_ids = Helper::get_students_ids_by_course_id( $course_id );
		/* translators: %s is a coursename. */
		$body = sprintf( 'New announcement publish for the course %s .', $announcement_course['label'] );

		foreach ( $student_ids as $student_id ) {
			Helper::insert_notification_details(
				array(
					'title' => __( 'Announcement Publish', 'academy-pro' ),
					'content' => $body,
					'status' => 'UNREAD',
					'receiver_id' => $student_id->post_author,
					'post_id'  => $course_id,
					'topic_id' => 0,
					'type' => 'announcement_publish',
					'created_at' => current_time( 'mysql' ),
				)
			);
		}
	}

	public function after_instructor_registration_onsite( $user_id ) {
		if ( ! Helper::get_setting( $this->settings['instructor_registration'] ) ) {
			return;
		}
		$admin_data = get_users(
			array( 'role' => 'administrator' )
		);
		if ( empty( $admin_data ) ) {
			return;
		}
		$user_data = get_userdata( $user_id );
		/* translators: %s is a username. */
		$body  = sprintf( __( 'New Instructor Registration Approval Request by %s', 'academy-pro' ), $user_data->display_name );

		foreach ( $admin_data as $admin ) {
			Helper::insert_notification_details(
				array(
					'title' => __( 'Instructor Approval Request', 'academy-pro' ),
					'content' => $body,
					'status' => 'UNREAD',
					'receiver_id' => $admin->ID,
					'post_id'  => 0,
					'topic_id' => 0,
					'type' => 'instructor-approval-request',
					'created_at' => current_time( 'mysql' ),
				)
			);
		}
	}

	public function after_student_registration_onsite( $user_id ) {
		if ( ! Helper::get_setting( $this->settings['student_registration'] ) ) {
			return;
		}
		$admin_data = get_users(
			array( 'role' => 'administrator' )
		);
		if ( empty( $admin_data ) ) {
			return;
		}
		$user_data = get_userdata( $user_id );
		/* translators: %s is a username */
		$body = sprintf( __( 'New Student %s Registration Successfully', 'academy-pro' ), $user_data->display_name );
		foreach ( $admin_data as $admin ) {
			Helper::insert_notification_details(
				array(
					'title' => __( 'Student Registration', 'academy-pro' ),
					'content' => $body,
					'status' => 'UNREAD',
					'receiver_id' => $admin->ID,
					'post_id' => 0,
					'topic_id' => 0,
					'type' => 'student-registration',
					'created_at' => current_time( 'mysql' ),
				)
			);
		}
	}

	public function after_academy_course_publish_onsite( $new_status, $old_status, $post ) {
		if ( ! Helper::get_setting( $this->settings['course_publish'] ) ) {
			return;
		}

		if ( 'academy_courses' === $post->post_type && 'publish' === $new_status && 'publish' !== $old_status ) {
			Helper::insert_notification_details(array(
				'title' => __( 'New Course Publish', 'academy-pro' ),
				/* translators: %s is a coursename. */
				'content' => sprintf( __( 'You have Published A New Course %s', 'academy-pro' ), $post->post_title ),
				'status' => 'UNREAD',
				'receiver_id' => $post->post_author,
				'post_id' => $post->ID,
				'topic_id' => 0,
				'type' => 'academy_courses',
				'created_at' => current_time( 'mysql' ),
			));
		}
	}

	public function after_course_complete_onsite( $course_id, $user_id ) {
		if ( ! Helper::get_setting( $this->settings['course_complete'] ) ) {
			return;
		}
		$instructors = \Academy\Helper::get_instructors_by_course_id( $course_id );
		if ( empty( $instructors ) ) {
			return;
		}
		foreach ( $instructors as $instructor ) {
			Helper::insert_notification_details(array(
				'title' => __( 'Course Completed', 'academy-pro' ),
				/* translators: %s is a username */
				'content' => sprintf( __( 'Hey %1$s, Successfully Your student %2$s Complete a course %3$s', 'academy-pro' ), $instructor->display_name, get_userdata( $user_id )->display_name, get_the_title( $course_id ) ),
				'status' => 'UNREAD',
				'receiver_id' => $instructor->ID,
				'post_id' => $course_id,
				'topic_id' => 0,
				'type' => 'academy_courses',
				'created_at' => current_time( 'mysql' ),
			));
		}
	}

	public function after_new_course_review_onsite( $comment ) {
		if ( ! Helper::get_setting( $this->settings['course_review'] ) ) {
			return;
		}

		if ( ! (bool) $comment->comment_approved && 'academy_courses' !== $comment->comment_type ) {
			return;
		}

		$instructors = \Academy\Helper::get_instructors_by_course_id( $comment->comment_post_ID );
		foreach ( $instructors as $instructor ) {
			Helper::insert_notification_details(array(
				'title' => __( 'Course Review', 'academy-pro' ),
				/* translators: %s is a username, %s is a courratingsename, %s is a coursename. */
				'content' => sprintf( __( 'Hey, %1$s! You have found %2$s star rating of this course %3$s', 'academy-pro' ), $instructor->display_name, get_comment_meta( $comment->comment_ID, 'academy_rating', true ), get_the_title( $comment->comment_post_ID ) ),
				'status' => 'UNREAD',
				'receiver_id' => $instructor->ID,
				'post_id' => $comment->comment_post_ID,
				'topic_id' => 0,
				'type' => 'academy_courses',
				'created_at' => current_time( 'mysql' ),
			));
		}
	}
	public function after_quiz_submit_onsite( $quiz_data ) {
		if ( ! Helper::get_setting( $this->settings['quiz_submit'] ) ) {
			return;
		}

		$course_id = $quiz_data->course_id;
		$instructors = \Academy\Helper::get_instructors_by_course_id( $course_id );
		foreach ( $instructors as $instructor ) {
			Helper::insert_notification_details(array(
				'title' => __( 'Quiz Submit', 'academy-pro' ),
				'content' => __( 'A new quiz has been submitted', 'academy-pro' ),
				'status' => 'UNREAD',
				'receiver_id' => $instructor->ID,
				'post_id' => $quiz_data->course_id,
				'topic_id' => 0,
				'type' => 'academy_quizzes',
				'created_at' => current_time( 'mysql' ),
			));
		}
	}

	public function after_quiz_attempt_manual_review_onsite( $attempt ) {
		if ( ! Helper::get_setting( $this->settings['quiz_evaluate'] ) ) {
			return;
		}
		$student = get_userdata( $attempt['student_id'] );

		Helper::insert_notification_details(array(
			'title' => __( 'Quiz Reviewed', 'academy-pro' ),
			/* translators: %s is a username. */
			'content' => sprintf( __( 'Hey, %1$s! A quiz has been reviewed.', 'academy-pro' ), $student->display_name ),
			'status' => 'UNREAD',
			'receiver_id' => $attempt['user_id'],
			'post_id' => $attempt['course_id'],
			'topic_id' => $attempt['quiz_id'],
			'type' => 'evaluate_quiz',
			'created_at' => current_time( 'mysql' ),
		));
	}

	public function after_assignment_submit_onsite( $assignment_data ) {
		if ( ! Helper::get_setting( $this->settings['assignment_submit'] ) ) {
			return;
		}

		$course_id = $assignment_data->comment_parent;
		$instructors = \Academy\Helper::get_instructors_by_course_id( $course_id );
		foreach ( $instructors as $instructor ) {
			Helper::insert_notification_details(array(
				'title' => __( 'Assignment Submit', 'academy-pro' ),
				'content' => __( 'A new assignment has been submitted', 'academy-pro' ),
				'status' => 'UNREAD',
				'receiver_id' => $instructor->ID,
				'post_id' => $assignment_data->comment_post_ID,
				'topic_id' => 0,
				'type' => 'academy_pro_assignments',
				'created_at' => current_time( 'mysql' ),
			));
		}
	}

	public function after_assignment_evaluate_onsite( $assignment_data ) {
		if ( ! Helper::get_setting( $this->settings['assignment_evaluate'] ) ) {
			return;
		}

		$student = get_userdata( $assignment_data->user_id );

		Helper::insert_notification_details(array(
			'title' => __( 'Assignment Reviewed', 'academy-pro' ),
			/* translators: %s is a username. */
			'content' => sprintf( __( 'Hey, %1$s! An assignment has been reviewed.', 'academy-pro' ), $student->display_name ),
			'status' => 'UNREAD',
			'receiver_id' => $assignment_data->user_id,
			'post_id' => $assignment_data->course_id,
			'topic_id' => $assignment_data->assignment_id,
			'type' => 'evaluate_assignments',
			'created_at' => current_time( 'mysql' ),
		));
	}

	public function after_withdraw_request_updated_onsite( $result ) {
		$isApproved = ( 'approved' === $result->status && Helper::get_setting( $this->settings['withdraw_request_approved'] ) );
		$isRejected = ( 'rejected' === $result->status && Helper::get_setting( $this->settings['withdraw_request_rejected'] ) );

		if ( $isApproved || $isRejected ) {
			$name = $result->user_login;
			/* translators: %s is a username., %s is a username */
			$content = $isApproved ? sprintf( __( 'Congratulations, %s! Your submitted withdraw request is Approved.', 'academy-pro' ), $name ) : sprintf( __( 'Alas, %s! Your submitted withdraw request is Rejected.', 'academy-pro' ), $name );
			$status = $isApproved ? __( 'Approved', 'academy-pro' ) : __( 'Rejected', 'academy-pro' );
			Helper::insert_notification_details(
				array(
					// translators: %s is request status
					'title' => sprintf( __( 'Withdraw Request %s', 'academy-pro' ), $status ),
					'content' => $content,
					'status' => 'UNREAD',
					'receiver_id' => $result->user_id,
					'post_id'  => 0,
					'topic_id' => 0,
					'type' => 'withdraw-request',
					'created_at' => current_time( 'mysql' ),
				)
			);
		}
	}

	public function course_question_answer_insert_onsite( $comment ) {
		if ( ! Helper::get_setting( $this->settings['question_answer_submit'] ) || 'waiting_for_answer' !== $comment['status'] ) {
			return;
		}
		$author_id = get_post( $comment['post'] )->post_author;
		$course_name = get_the_title( $comment['post'] );
		Helper::insert_notification_details(array(
			'title' => __( 'User Course Question', 'academy-pro' ),
			/* translators: %s is a username., %s is a coursename */
			'content' => sprintf( __( 'Hey, your student %1$s submitted question in a course of %2$s', 'academy-pro' ), $comment['author_name'], $course_name ),
			'status' => 'UNREAD',
			'receiver_id' => $author_id,
			'post_id' => $comment['post'],
			'topic_id' => 0,
			'type' => 'question_answer_submit',
			'created_at' => current_time( 'mysql' ),
		));
	}

	public function course_question_answer_reply_onsite( $comment ) {
		if ( ! Helper::get_setting( $this->settings['question_answer_reply'] ) || 'answered' !== $comment['status'] ) {
			return;
		}
		$receiver_id = get_comment( $comment['parent'] )->user_id;
		$student_name = get_userdata( $receiver_id )->display_name;
		$course_name = get_the_title( $comment['post'] );
		Helper::insert_notification_details(array(
			'title' => __( 'Course Question Reply', 'academy-pro' ),
			/* translators: %s is a username., %s is a coursename */
			'content' => sprintf( __( 'Hey %1$s, your submitted question has replied in a course of %2$s', 'academy-pro' ), $student_name, $course_name ),
			'status' => 'UNREAD',
			'receiver_id' => $receiver_id,
			'post_id' => $comment['post'],
			'topic_id' => 0,
			'type' => 'question_answer_reply',
			'created_at' => current_time( 'mysql' ),
		));
	}
}
