<?php
namespace AcademyProMailChimp;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Helper;
use Academy\Interfaces\AddonInterface;

final class MailChimp implements AddonInterface {
	private $addon_name = 'mail_chimp';

	public function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public function define_constants() {
		/**
		 * Define constant for whole addon
		 */
		define( 'ACADEMY_PRO_MAILCHIMP_VERSION', '1.0' );
		define( 'ACADEMY_PRO_MAILCHIMP_SETTINGS_NAME', 'academy_pro_mailchimp_settings' );
	}

	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		MailChimpService::init();
		Ajax::init();

	}

	public static function init() {
		static $instance = false;

		// check if the instance is create
		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function addon_activation_hook() {
		Admin\Settings::save_settings();
	}
}
