<?php
namespace AcademyProGroupPlus\Roles\Abstracts;

use AcademyProGroupPlus\Interfaces\Roles\RoleInterface;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


abstract class Role implements RoleInterface {

	protected array $caps = [];
	public function role_name() : string {
		return '';
	}

	public static function init(): void {
		$instance = new static();
		$instance->add_roles();
		// add_action('init',[$instance, 'add_roles']);
	}

	public function add_roles() : void {
		global $wp_roles;
		if ( empty( $wp_roles->roles[ static::ROLE_SLUG ] ?? '' ) ) {
			$role = add_role(
				static::ROLE_SLUG,
				$this->role_name()
			);
		} else {
			$role = get_role( static::ROLE_SLUG );
		}

		if ( $role && ! empty( $this->caps ) ) {
			foreach ( $this->caps as $cap ) {
				$role->add_cap( $cap );
			}
		}
	}
}
