<?php
namespace AcademyProGroupPlus\interfaces\Db;

use AcademyProGroupPlus\Db\Common;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

interface ModelInterface {


	public static function ins();
	public function get_by_id( int $id) : ?array;

	public function get(
		array $conditions = [],
		array $args = [],
		int $per_page = 20,
		int $current_page = 1,
		?string $order_by = null,
		string $order_direction = 'DESC'
	) : array;

	public function delete( array $where) : bool;
	public function create( array $data) : ?int;
	public function update( array $data, array $where) : bool;

	public function get_advance(
		string $select,
		string $count_col,
		string $table_alias,
		string $join,
		array $where,
		array $args,
		string $after_query = '',
		int $per_page = 20,
		int $current_page = 1,
		?string $order_by = null,
		string $order_direction = 'DESC'
	) : array;

	public function get_advance_ct(
		string $select,
		string $count_col,
		string $table,
		string $join,
		array $where,
		array $args,
		string $after_query = '',
		int $per_page = 20,
		int $current_page = 1,
		?string $order_by = null,
		string $order_direction = 'DESC'
	) : array;

	public static function get_format_by_data_type( array $data) : array;
}
