<?php
namespace AcademyProGroupPlus;

use AcademyProGroupPlus\Db\Migrations\{
	CreateGroupsTable,
	CreateGroupCoursesTable,
	CreateGroupOrganizersTable,
	CreateTeamsTable,
	CreateTeamMembersTable,
	CreateTeamCoursesTable,
	CreateTeamOrganizersTable
};

use AcademyProGroupPlus\Roles\{
	GroupOrganizer,
	TeamOrganizer,
	TeamMember,
	GiveFrontendManagementCapabilityToAdmin,
	GiveFrontendManagementCapabilityToEditor
};

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class Installation
 */
final class Installation {

	protected array $migrations = [
		CreateGroupsTable::class,
		CreateGroupCoursesTable::class,
		CreateGroupOrganizersTable::class,
		CreateTeamsTable::class,
		CreateTeamMembersTable::class,
		CreateTeamCoursesTable::class,
		CreateTeamOrganizersTable::class,
	];

	protected array $roles = [
		GroupOrganizer::class,
		TeamOrganizer::class,
		TeamMember::class,
		GiveFrontendManagementCapabilityToAdmin::class,
		GiveFrontendManagementCapabilityToEditor::class,
	];

	/**
	 * @method init
	 * @return void
	 */
	public static function init(): void {
		$instance = new self();

		$instance->run_migration();
		$instance->add_roles();
	}

	/**
	 * @method init
	 * @return void
	 */
	public function run_migration() : void {
		foreach ( $this->migrations as $migration ) {
			$migration::runOnActivation();
		}
	}
	public function add_roles() : void {
		foreach ( $this->roles as $role ) {
			$role::init();
		}
	}
}
