<?php
namespace AcademyProGroupPlus;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Hooks {
	public static function init() {
		$self = new self();
		add_filter( 'academy/course/is_enrolled', [ $self, 'check_team_member_enroll' ], 10, 3 );
		add_filter( 'academy/count_course_enrolled', [ $self, 'count_course_enrolled' ], 10, 2 );

	}
	public function check_team_member_enroll( $enrolled_status, $course_id, $user_id ) {
		$is_group_member_enrolled = Helper::ins()->is_team_member_enrolled( (int) $course_id, (int) $user_id );
		if ( $is_group_member_enrolled ) {
			return $is_group_member_enrolled;
		}
		return $enrolled_status;
	}
	public function count_course_enrolled( $enrolled_course_count, $course_id ) {
		return $enrolled_course_count + Helper::ins()->total_seat_count_by_course( $course_id );
	}

}
