<?php
namespace AcademyProGroupPlus;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Helper;
use Academy\Interfaces\AddonInterface;
use AcademyProGroupPlus\Integration\Woocommerce\Woocommerce;
use AcademyProGroupPlus\Integration\Storeengine\Storeengine;

final class GroupPlus implements AddonInterface {
	private $addon_name = 'group-plus';

	public function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public function define_constants() {
		/**
		 * Define constant for whole addon
		 */
		define( 'ACADEMY_PRO_GROUPPLUS_VERSION', '1.0' );
	}

	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		$this->load_hooks_and_functions();
		\AcademyProGroupPlus\Dashboard\Ajax\Frontend\GroupMenu::init();
		Ajax::init();
		Woocommerce::init();
		Storeengine::init();
		Hooks::init();
	}

	public static function init() {
		static $instance = false;

		// check if the instance is create
		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function load_hooks_and_functions() {
		require_once ACADEMY_PRO_ADDONS_DIR_PATH . 'group-plus/frontend/functions.php';
		require_once ACADEMY_PRO_ADDONS_DIR_PATH . 'group-plus/frontend/hooks.php';
	}

	public function addon_activation_hook() {
		Installation::init();
	}
}
