<?php
use Academy\Helper;
use AcademyProGroupPlus\Db\Models\{
	Group,
	Team
};
use StoreEngine\Utils\Formatting;
use StoreEngine\Utils\Helper as StoreEngineHelper;
use AcademyProGroupPlus\Integration\Woocommerce\Woocommerce;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
function academy_pro_group_plus_bulk_purchase_from_product_single() {

	$is_academy_course = ! empty(
		Woocommerce::get_course_id_by_product_id( get_the_ID() )
	);
	if ( ! $is_academy_course ) {
		return;
	}

	\AcademyPro\Helper::get_template( 'group-plus/group-purchase-from-product-form.php', [] );
}

function academy_pro_group_plus_add_enroll_widget_tab_head() {
	$course_id = get_the_ID();
	if (
		! Helper::is_enrolled( $course_id, get_current_user_id(), 'any' ) &&
		property_exists( $GLOBALS['academy_settings'], 'monetization_engine' ) &&
		! empty( $GLOBALS['academy_settings']->monetization_engine ) &&
		Helper::get_course_type( $course_id ) == 'paid'
	) {
		$engine = $GLOBALS['academy_settings']->monetization_engine;
		$data = apply_filters( "academy_pro/group_plus/{$engine}/product_data", [], (int) $course_id );
		if ( empty( $data ) ) {
			return;
		}
		\AcademyPro\Helper::get_template( 'group-plus/tab-head.php', [] );
	}
}

function academy_pro_group_plus_add_enroll_widget_team_content() {
	$course_id = get_the_ID();
	if (
		! Helper::is_enrolled( $course_id, get_current_user_id(), 'any' ) &&
		property_exists( $GLOBALS['academy_settings'], 'monetization_engine' ) &&
		! empty( $GLOBALS['academy_settings']->monetization_engine ) &&
		Helper::get_course_type( $course_id ) == 'paid'
	) {
		$engine = $GLOBALS['academy_settings']->monetization_engine;
		$data = apply_filters( "academy_pro/group_plus/{$engine}/product_data", [], (int) $course_id );
		if ( empty( $data ) ) {
			return;
		}
		\AcademyPro\Helper::get_template( 'group-plus/group-purchase-form.php', $data );
	}
}

function academy_pro_group_plus_load_assets() {
	wp_enqueue_script(
		'academy-group-static-js',
		ACADEMY_PRO_PLUGIN_ROOT_URI . 'addons/group-plus/assets/js/bulk-purchase.js',
		[ 'jquery' ],
		'0.0.1', true
	);

	wp_localize_script(
		'academy-group-static-js',
		'academy_group',
		[
			'ajax_url' => admin_url( 'admin-ajax.php' ),
			'nonce'    => wp_create_nonce( 'academy_nonce' ),
		]
	);
	wp_enqueue_style(
		'academy-group-static-css',
		ACADEMY_PRO_PLUGIN_ROOT_URI . 'addons/group-plus/assets/css/bulk-purchase.css',
		[],
		'0.0.1'
	);
}
