<?php
namespace AcademyProGroupPlus\Db\Migrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class CreateGroupsTable
 */
final class CreateTeamsTable extends Migration {

	/** @var string $table */
	protected string $table = 'teams';

	/**
	 * @method up
	 * Run query on addon activation
	 * @return string
	 */
	public function up(): string {
		return "
			CREATE TABLE IF NOT EXISTS {$this->table}
			(
				id          INT 	     AUTO_INCREMENT PRIMARY KEY,
				name        VARCHAR(255) NULL,
				description LONGTEXT     NULL,
				user_id     BIGINT(20)   NULL,
				group_id    INT          NOT NULL COMMENT 'Group ID', 
				created_at  TIMESTAMP    DEFAULT CURRENT_TIMESTAMP,
				updated_at  TIMESTAMP    DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				FOREIGN KEY (group_id) 
					REFERENCES {$this->prefix}groups(id)
						ON DELETE CASCADE
						ON UPDATE CASCADE
			) {$this->charset_collate};
		";
	}

	/**
	 * @method down
	 * Run query on addon deactivation
	 * @return string
	 */
	public function down(): string {
		// nothing
		return '';
	}

}
