<?php
namespace AcademyProGroupPlus\Db\Migrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class CreateGroupsTable
 */
final class CreateGroupsTable extends Migration {

	/** @var string $table */
	protected string $table = 'groups';

	/**
	 * @method up
	 * Run query on addon activation
	 * @return string
	 */
	public function up(): string {
		return "
			CREATE TABLE IF NOT EXISTS {$this->table}
			(
				id            INT 	       AUTO_INCREMENT PRIMARY KEY,
				name          VARCHAR(255) NULL,
				description   LONGTEXT     NULL,
				team_limit    SMALLINT     DEFAULT 100,
				member_limit  SMALLINT     DEFAULT 500,
				is_prebuilt   BOOLEAN      DEFAULT 0,
				user_id       BIGINT(20)   NULL,
				created_at    TIMESTAMP    DEFAULT CURRENT_TIMESTAMP,
				updated_at    TIMESTAMP    DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
			) {$this->charset_collate};
		";
	}

	/**
	 * @method down
	 * Run query on addon deactivation
	 * @return string
	 */
	public function down(): string {
		// nothing
		return '';
	}

}
