<?php

namespace AcademyProGroupPlus\Dashboard\Ajax\Frontend;

use AcademyPro\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class GroupMenu {

	public static function init(): void {
		$self = new self();
		add_action( 'academy_frontend_dashboard_group-plus_endpoint', [ $self, 'page' ] );
		add_filter( 'academy/frontend_dashboard_menu_items', [ $self, 'menu' ], 10, 1 );
	}

	public function page() : void {
		Helper::get_template(
			'frontend-dashboard/pages/group-plus.php',
			[]
		);
	}

	public function menu( array $menu ) : array {
		$user = wp_get_current_user();
		$allowed_roles = [ 'academy_team_organizer', 'academy_group_organizer' ];
		$public = array_intersect( $allowed_roles, $user->roles ) !== [];

		$menu['group-plus'] = [
			'label'    => __( 'Group Plus', 'academy-pro' ),
			'icon'     => 'academy-icon academy-icon--group-plus',
			'public'   => $public,
			'priority' => 36,
		];
		return $menu;
	}

}
