<?php
namespace AcademyProGroupPlus;

use AcademyProGroupPlus\Dashboard\Ajax\Admin\{
	GroupHandler,
	OrganizerHandler,
	TeamHandler,
};
use AcademyProGroupPlus\Dashboard\Ajax\Frontend\{
	GroupHandler as FrontendGroupHandler,
	TeamHandler as FrontendTeamHandler,
	EcommerceInegration
};

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


final class Ajax {

	protected array $ajax_handlers = [
		GroupHandler::class,
		OrganizerHandler::class,
		TeamHandler::class,

		FrontendGroupHandler::class,
		FrontendTeamHandler::class,
		EcommerceInegration::class
	];

	public static function init(): void {
		$instance = new self();

		$instance->dispatch();
	}

	function dispatch() : void {
		foreach ( $this->ajax_handlers as $class ) {
			( new $class() )->dispatch_actions();
		}
	}
}
