<?php
namespace AcademyProGradeBook;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Admin\Settings;

class Installer {
	public static function init() {
		$self = new self();
		$self->create_database();
	}

	public function create_database(): void {
		Database::init();

		$is_already_imported = Helper::get_all_grades( array(
			'per_page' => 10,
			'offset' => 0,
		));

		if ( ! $is_already_imported ) {
			Helper::import_grade_book_sample_data();
		}
	}
}
