<?php

namespace AcademyProGradeBook;

class Hooks {
	public static function init() {
		$self = new self();
		// for frontend dashboard
		add_filter( 'academy_quizzes/api/before_quiz_attempts', array( $self, 'modify_quiz_attempt_student' ) );
		add_filter( 'academy_pro_assignments/frontend/evaluate_submitted_assignment', array( $self, 'modify_submitted_assignments_student' ), 10, 4 );

		// for backend dashboard
		add_filter( 'academy_quizzes/api/quiz_attempt_item', array( $self, 'modify_quiz_attempt_admin' ) );
		add_filter( 'academy_pro_assignments/admin/submitted_assignments', array( $self, 'modify_submitted_assignments_admin' ) );
		add_filter( 'academy_pro_assignments/admin/before_evaluate_assignment', array( $self, 'modify_assignment_data_before_evaluate' ) );

		// for quiz and assignment ui
		add_filter( 'academy_quizzes/frontend/quiz_attempts', array( $self, 'get_latest_quiz_attempt' ), 10, 2 );
		add_filter( 'academy_pro_assignments/frontend/berfore_render_result', array( $self, 'add_assignment_grade_to_evaluated_assignment' ), 10, 4 );
	}

	public function modify_quiz_attempt_student( $attempts ) {
		$attempt = current( $attempts );

		$latest_attempt_grade = Helper::get_student_quiz_grade_by_course_quiz_and_user_id( array(
			'course_id' => isset( $attempt->course_id ) ? $attempt->course_id : 0,
			'quiz_id' => isset( $attempt->quiz_id ) ? $attempt->quiz_id : 0,
			'user_id' => get_current_user_id(),
		) );

		if ( $latest_attempt_grade ) {
			$latest_attempt_grade = current( $latest_attempt_grade );
			$latest_attempt_grade->grade_config = maybe_unserialize( $latest_attempt_grade->grade_config );
			$attempt->grade_details = $latest_attempt_grade;
		}

		return $attempts;
	}

	public function modify_submitted_assignments_student( $assignment, $course_id, $user_id, $assignment_id ) {
		if ( $assignment->submitted_assignment && $assignment->submitted_assignment->meta['academy_pro_assignment_evaluate_point'] ) {
			$args = array(
				'user_id'         => $user_id,
				'course_id'       => $course_id,
				'assignment_id'   => $assignment_id,
			);

			$grade_book_result = Helper::get_student_assignment_grade_by_course_assignment_and_user_id( $args );

			if ( $grade_book_result ) {
				$grade_book_result = current( $grade_book_result );
				$grade_book_result->grade_config = maybe_unserialize( $grade_book_result->grade_config );
				$assignment->gradebook_result = $grade_book_result;
			}
		}

		return $assignment;
	}

	public function modify_quiz_attempt_admin( $attempt ) : array {
		$latest_attempt_grade = Helper::get_student_quiz_grade_by_course_quiz_and_user_id( array(
			'course_id' => $attempt['course_id'],
			'quiz_id' => $attempt['quiz_id'],
			'user_id' => get_current_user_id(),
		) );

		if ( $latest_attempt_grade ) {
			$latest_attempt_grade = current( $latest_attempt_grade );
			$latest_attempt_grade->grade_config = maybe_unserialize( $latest_attempt_grade->grade_config );
			$attempt['grade_details'] = $latest_attempt_grade;
		}

		return $attempt;
	}

	public function modify_submitted_assignments_admin( $assignments ) {
		foreach ( $assignments as $assignment ) {
			$args = array(
				'user_id'         => $assignment->user_id,
				'course_id'       => $assignment->comment_parent,
				'assignment_id'   => $assignment->comment_post_ID,
			);

			$grade_book_result = Helper::get_student_assignment_grade_by_course_assignment_and_user_id( $args );

			if ( $grade_book_result ) {
				$grade_book_result = current( $grade_book_result );
				$grade_book_result->grade_config = maybe_unserialize( $grade_book_result->grade_config );
				$assignment->gradebook_result = $grade_book_result;
			}
		}
		return $assignments;
	}

	public function get_latest_quiz_attempt( $response, $args ) {
		if ( \Academy\Helper::get_addon_active_status( 'quizzes' ) ) {
			$latest_attempt_grade = Helper::get_student_quiz_grade_by_course_quiz_and_user_id( array(
				'course_id' => isset( $args['course_id'] ) ? $args['course_id'] : 0,
				'quiz_id' => isset( $args['quiz_id'] ) ? $args['quiz_id'] : 0,
				'user_id' => get_current_user_id(),
			) );

			if ( $latest_attempt_grade ) {
				$latest_attempt_grade = current( $latest_attempt_grade );
				$latest_attempt_grade->grade_config = maybe_unserialize( $latest_attempt_grade->grade_config );
				$response[0]['grade_details'] = $latest_attempt_grade;
			}
		}

		return $response;
	}

	public function add_assignment_grade_to_evaluated_assignment( $assignment, $course_id, $user_id, $assignment_id ) {
		if ( \Academy\Helper::get_addon_active_status( 'assignments' ) ) {
			if ( $assignment->submitted_assignment && $assignment->submitted_assignment->meta['academy_pro_assignment_evaluate_point'] ) {
				$args = array(
					'user_id'         => $user_id,
					'course_id'       => $course_id,
					'assignment_id'   => $assignment_id,
				);

				$grade_book_result = Helper::get_student_assignment_grade_by_course_assignment_and_user_id( $args );

				if ( $grade_book_result ) {
					$grade_book_result = current( $grade_book_result );
					$grade_book_result->grade_config = maybe_unserialize( $grade_book_result->grade_config );
					$assignment->gradebook_result = $grade_book_result;
				}
			}
		}

		return $assignment;
	}

	public function modify_assignment_data_before_evaluate( $response ) {
		if ( \Academy\Helper::get_addon_active_status( 'assignments' ) && ! empty( $response ) ) {
			$gradebook_result = Helper::get_student_assignment_grade_by_course_assignment_and_user_id( array(
				'user_id'       => $response->user_id,
				'course_id'     => $response->comment_parent,
				'assignment_id' => $response->comment_post_ID,
			) );
			if ( $gradebook_result ) {
				$gradebook_result               = current( $gradebook_result );
				$gradebook_result->grade_config = maybe_unserialize( $gradebook_result->grade_config );
				$response->gradebook_result     = $gradebook_result;
			}
		}

		return $response;
	}
}
