<?php
namespace AcademyProGradeBook;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;

final class GradeBook implements AddonInterface {
	private $addon_name = 'grade_book';
	public function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		// check if the instance is create
		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function define_constants(): void {
		/**
		 * Define constant for whole addon
		 */
		define( 'ACADEMY_PRO_GRADE_BOOK_VERSION', '1.0' );
		define( 'ACADEMY_PRO_GRADE_BOOK_VERSION_NAME', 'academy_pro_grade_book_version' );
	}

	public function init_addon(): void {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		Ajax::init();
		Hooks::init();
	}

	public function addon_activation_hook(): void {
		Installer::init();
		flush_rewrite_rules();
	}
}


