<?php
namespace AcademyProGradeBook\Database;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CreateGradeBooksTable {
	public static function create( $prefix, $charset_collate ): void {
		$table_name = $prefix . ACADEMY_PLUGIN_SLUG . '_grade_books';
		$sql        = "CREATE TABLE IF NOT EXISTS $table_name (
			gradebook_id bigint(20) unsigned NOT NULL auto_increment,
			grade_name varchar(20) NOT NULL,
			grade_point decimal(5,2) NOT NULL,
			percent_from decimal(5,2) NOT NULL,
			percent_to decimal(5,2) NOT NULL,
			grade_config text NOT NULL,
			created_at datetime DEFAULT NULL,
			updated_at datetime DEFAULT NULL,
			PRIMARY KEY (gradebook_id)
		) $charset_collate;";
		dbDelta( $sql );
	}
}
