<?php
namespace  AcademyProGradeBook\Database;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class CreateGradeBookResultsTable {
	public static function create( $prefix, $charset_collate ): void {
		$table_name = $prefix . ACADEMY_PLUGIN_SLUG . '_grade_book_results';
		$sql        = "CREATE TABLE IF NOT EXISTS $table_name (
			gradebook_result_id bigint(20) unsigned NOT NULL auto_increment,
			user_id bigint(20) NOT NULL,
			course_id bigint(20) NOT NULL,
			quiz_id bigint(20) DEFAULT NULL,
			assignment_id bigint(20) DEFAULT NULL,
			gradebook_id bigint(20) DEFAULT NULL,
			result_for varchar(20) NOT NULL,
			grade_name varchar(20) NOT NULL,
			grade_point decimal(5,2) NOT NULL,
			user_grade_point decimal(5,2) NOT NULL,
			earned_percentage decimal(5,2) NOT NULL,
			created_at datetime DEFAULT NULL,
			updated_at datetime DEFAULT NULL,
			PRIMARY KEY ( gradebook_result_id )
		) $charset_collate;";
		dbDelta( $sql );
	}
}
