<?php
namespace AcademyProGoogleClassroom;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;
final class GoogleClassroom implements AddonInterface {
	private $addon_name = 'google-classroom';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		define( 'ACADEMY_PRO_GOOGLE_CLASSROOM_VERSION', '1.0' );
	}

	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		Ajax::init();
		Hooks::init();
	}

	public function addon_activation_hook() {
		flush_rewrite_rules();
	}
}


