<?php
namespace AcademyProGamipress;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;

final class Gamipress implements AddonInterface {
	private $addon_name = 'gamipress';
	public function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		// check if the instance is create
		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function define_constants(): void {
		/**
		 * Define constant for whole addon
		 */
		define( 'ACADEMY_PRO_GAMIPRESS_VERSION', '1.0' );
		define( 'ACADEMY_PRO_GAMIPRESS_SETTINGS_NAME', 'academy_pro_gamipress_settings' );
	}

	public function init_addon(): void {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) || ! Helper::is_gamipess_active() ) {
			return;
		}

		Integrations::init();
		Hooks::init();
		Ajax::init();
	}

	public function addon_activation_hook(): void {
		Admin\Settings::save_settings();
	}
}


