<?php

namespace AcademyProGamipress\Ajax;

use Academy\Classes\AbstractAjaxHandler;
use AcademyProGamipress\Helper;

class Admin extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_gamipress';
	public function __construct() {
		$this->actions = array(
			'get_points_types' => array(
				'callback' => array( $this, 'get_points_types' ),
			),
			'get_achievements_types' => array(
				'callback' => array( $this, 'get_achievements_types' ),
			),
			'get_ranks_types' => array(
				'callback' => array( $this, 'get_ranks_types' ),
			),
		);
	}

	public function get_points_types() {
		wp_send_json_success( \AcademyProGamipress\Helper::get_reward_types_by_reward_name( 'points' ) );
	}

	public function get_achievements_types() {
		wp_send_json_success( \AcademyProGamipress\Helper::get_reward_types_by_reward_name( 'achievements' ) );
	}

	public function get_ranks_types() {
		wp_send_json_success( \AcademyProGamipress\Helper::get_reward_types_by_reward_name( 'ranks' ) );
	}
}
