<?php

namespace AcademyProFluentCRM;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Academy\Helper;
use Academy\Interfaces\AddonInterface;


final class FluentCRM implements AddonInterface {
	private $addon_name = 'fluent-crm';


	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_FLUENT_CRM_VERSION', '1.0' );
	}

	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! Helper::get_addon_active_status( $this->addon_name ) || ! Helper::is_plugin_active( 'fluent-crm/fluent-crm.php' ) ) {
			return;
		}

		// Run Addon functionality
		Integrations::init();

	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function addon_activation_hook() {

	}
}
