<?php

namespace AcademyProFluentCommunity\Feeds;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use stdClass;
class QuizEndFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy_quizzes/api/after_quiz_attempt_finished',
			[ $this, 'notify' ],
			999, 3
		);
	}
	public function notify( stdClass $quiz ): void {
		if (
			empty( $quiz->course_id ) ||
			empty( $quiz->user_id )
		) {
			return;
		}

		$course_permalink = get_permalink( $quiz->course_id );
		$course_title = get_the_title( $quiz->course_id );
		$user = get_userdata( $quiz->user_id );
		$this->course_id = $quiz->course_id;
		$this->title     = __( 'Quiz Solved', 'academy-pro' );
		$this->message   = sprintf(
			/* translators: %s is the username */
			'<p>%s ' . __( 'solved a', 'academy-pro' ) . ' <a href="%s">' . __( 'quiz', 'academy-pro' ) . '</a> ' . __( 'at %s.', 'academy-pro' ) . ' ' . __( 'Now, it\'s your turn to give it a try!', 'academy-pro' ) . '</p>',
			wp_strip_all_tags( $user ? $user->display_name : '' ),
			esc_url( $course_permalink ),
			wp_strip_all_tags( $course_title )
		);
		$this->event     = 'quiz_end';
		$this->push();
	}
}
