<?php
namespace AcademyProFluentCommunity\Feeds;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class NewEnrollmentFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy/course/after_enroll',
			[ $this, 'notify' ],
			10, 3
		);
	}
	public function notify( int $course_id, int $enroll_id, int $user_id ): void {

		if ( empty( $user_id ) ) {
			return;
		}

		$course_permalink = get_permalink( $course_id );
		$course_title = get_the_title( $course_id );
		$user = get_userdata( $user_id );

		$this->course_id = $course_id;

		$this->title     = sprintf(
			/* translators:  %s is the username, %s is the groupname */
			__( '%1$s is just enrolled @ %2$s!', 'academy-pro' ),
			esc_html( $user ? $user->display_name : '' ),
			esc_html( $course_title )
		);
		$this->message   = sprintf(
			/* translators: %s is the username */
			__( 'Please join us in welcoming %s, who has just enrolled in the', 'academy-pro' ) . ' <a href="%s">%s</a>! ' . __( '🎉 We\'re excited to have you on board. Get ready to dive into some amazing content and start your learning journey. Let\'s make this an awesome experience together!', 'academy-pro' ),
			esc_html( $user ? $user->display_name : '' ),
			esc_url( $course_permalink ),
			esc_html( $course_title )
		);
		$this->event     = 'course_enrollment';
		$this->push();
	}
}
