<?php
namespace AcademyProFluentCommunity\Feeds\Abstracts;

use AcademyProFluentCommunity\Feeds\Interfaces\{ Pushable, Initializable };
use AcademyProFluentCommunity\Classes\PushFeed;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

abstract class EventFeed implements Pushable, Initializable {

	public int $course_id;
	public string $title;
	public string $message;
	public string $event;

	public function push(): void {
		if ( ! boolval( get_post_meta( $this->course_id, 'is_fluent_community_feed_active', true ) ) ) {
			return;
		}

		( new PushFeed(
			$this->course_id,
			$this->title,
			$this->message,
			$this->event
		) )->post();
	}

}
