<?php
namespace AcademyProEmail;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Hooks {
	private $mail;
	private $settings;

	public static function init() {
		$self = new self();
		$self->settings = Admin\Settings::get_settings_saved_data();
		$self->mail = new Email\Mail();

		// Add data inside main settings
		add_filter( 'academy/api/settings/get_settings', array( $self, 'add_settings' ) );

		// Course Enroll
		add_action( 'academy/course/after_enroll', array( $self, 'enrolled_course_email_to_admin' ), 10, 3 );
		add_action( 'academy/course/after_enroll', array( $self, 'enrolled_course_email_to_instructor' ), 10, 3 );
		add_action( 'academy/course/after_enroll', array( $self, 'enrolled_course_email_to_student' ), 10, 3 );

		// Finished Course
		add_action( 'academy/admin/course_complete_after', array( $self, 'finished_course_email_to_admin' ), 10, 2 );
		add_action( 'academy/admin/course_complete_after', array( $self, 'finished_course_email_to_instructor' ), 10, 2 );
		add_action( 'academy/admin/course_complete_after', array( $self, 'finished_course_email_to_student' ), 10, 2 );

		// Become an instructor
		add_filter( 'academy/is_allow_new_instructor_notification', '__return_false' );
		add_action( 'academy/shortcode/after_instructor_registration', array( $self, 'instructor_register_email_to_admin' ) );
		add_action( 'academy_pro_email/after_verify_instructor_registration', array( $self, 'instructor_register_email_to_admin' ) );
		// to instructor
		add_action( 'academy/admin/after_register_instructor', array( $self, 'instructor_register_email_to_instructor' ) );
		add_action( 'academy/shortcode/after_instructor_registration', array( $self, 'instructor_register_email_to_instructor' ) );
		add_action( 'academy_pro_email/after_verify_instructor_registration', array( $self, 'instructor_register_email_to_instructor' ) );
		add_action( 'academy/admin/update_instructor_status', array( $self, 'become_an_instructor_accept' ), 10, 2 );
		add_action( 'academy/admin/update_instructor_status', array( $self, 'become_an_instructor_denied' ), 10, 2 );

		// Student
		add_filter( 'academy/is_allow_new_student_notification', '__return_false' );
		add_action( 'academy/shortcode/after_student_registration', array( $self, 'student_register_email_to_admin' ) );
		add_action( 'academy_pro_email/after_verify_student_registration', array( $self, 'student_register_email_to_admin' ), 10, 1 );
		// to student
		add_action( 'academy/shortcode/after_student_registration', array( $self, 'student_register_email_to_student' ) );
		add_action( 'academy_pro_email/after_verify_student_registration', array( $self, 'student_register_email_to_student' ), 10, 1 );
		add_action( 'academy/admin/after_register_student', array( $self, 'student_register_email_to_student' ) );
		// quiz submit and evaluate
		add_action( 'academy_quizzes/after_quiz_insert', array( $self, 'after_quiz_submit_to_admin' ) );
		add_action( 'academy_quizzes/after_quiz_insert', array( $self, 'after_quiz_submit_to_instructor' ) );
		add_action( 'academy_quizzes/after_quiz_attempt_manual_review', array( $self, 'after_quiz_attempt_manual_review_to_student' ) );
		// assignment submit and evaluate
		add_action( 'academy_pro/frontend/submitted_assignment', array( $self, 'after_assignment_submit_to_admin' ) );
		add_action( 'academy_pro/frontend/submitted_assignment', array( $self, 'after_assignment_submit_to_instructor' ) );
		add_action( 'academy_pro/frontend/evaluate_submitted_assignment', array( $self, 'after_assignment_evaluate_to_student' ) );
		// question submit and reply
		add_action( 'academy/frontend/insert_course_qa', array( $self, 'after_question_answer_submit_to_admin' ) );
		add_action( 'academy/frontend/insert_course_qa', array( $self, 'after_question_answer_submit_to_instructor' ) );
		add_action( 'academy/frontend/insert_course_qa_answered', array( $self, 'after_question_answer_reply_to_student' ) );
		// withdraw request
		add_action( 'academy/multi_instructor/withdraw_request_approved', array( $self, 'after_withdraw_request_approved' ) );
		add_action( 'academy/multi_instructor/withdraw_request_rejected', array( $self, 'after_withdraw_request_rejected' ) );

		// tutor booking booked
		add_action( 'academy_pro/booking/after_booked', array( $self, 'tutor_booked_email_to_admin' ), 10, 3 );
		add_action( 'academy_pro/booking/after_booked', array( $self, 'tutor_booked_email_to_instructor' ), 10, 3 );
		add_action( 'academy_pro/booking/after_booked', array( $self, 'tutor_booked_email_to_student' ), 10, 3 );

		// Two Step Email
		if ( (bool) $self->get_settings( 'email_verify', 'is_enable' ) ) {
			$EmailVerify = new Classes\EmailVerify();
			// Show Verification Message
			add_action( 'academy/templates/single_course_content', array( $EmailVerify, 'show_verify_email_message' ), 05 );
			add_action( 'academy/shortcode/before_academy_dashboard', array( $EmailVerify, 'show_verify_email_message' ) );
			// Verify user email after click email verify link
			add_action( 'template_redirect', array( $EmailVerify, 'verify_email_address' ) );
			// Send Verification Email
			add_action( 'academy/shortcode/before_student_registration', array( $EmailVerify, 'email_verification_registration' ), 10, 2 );
			add_action( 'academy/shortcode/before_instructor_registration', array( $EmailVerify, 'email_verification_registration' ), 10, 2 );
			// Prevent Login if not verify
			add_filter( 'wp_authenticate', array( $EmailVerify, 'restrict_unverified_users_login' ), 10 );
		}
	}

	public function add_settings( $settings ) {
		if ( ! isset( $settings['email'] ) ) {
			$settings['email'] = $this->settings;
		}
		return $settings;
	}

	private function get_settings( $template_name, $action_name ) {
		if ( isset( $this->settings[ $template_name ][ $action_name ] ) ) {
			return $this->settings[ $template_name ][ $action_name ];
		}
		return false;
	}

	private function get_global_setting( $setting_name ) {
		if ( isset( $this->settings[ $setting_name ] ) ) {
			return $this->settings[ $setting_name ];
		}
		return false;
	}

	public function enrolled_course_email_to_admin( $course_id, $enroll_id, $user_id ) {
		$settings = $this->get_settings( 'enrolled_course', 'admin' );
		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course = get_post( $course_id );
		$course_title = $course->post_title;
		$student_profile = get_edit_user_link( $student->ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/enrolled-course-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $student_profile ],
			$body
		);
		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function enrolled_course_email_to_instructor( $course_id, $enroll_id, $user_id ) {
		$settings = $this->get_settings( 'enrolled_course', 'instructor' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course = get_post( $course_id );
		$course_title = $course->post_title;
		$student_profile = get_edit_user_link( $student->ID );
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/enrolled-course-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{instructor_dashboard}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $dashboard, $student_profile ],
			$body
		);
		foreach ( Helper::get_instructors_email_by_course_id( $course_id ) as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function enrolled_course_email_to_student( $course_id, $enroll_id, $user_id ) {
		$settings = $this->get_settings( 'enrolled_course', 'user' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student     = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course_title = get_the_title( $course_id );
		$permalink = get_permalink( $course_id );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/enrolled-course-user.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{course_url}' ],
			[ $user_display_name, $user_email, $course_title, $permalink ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function finished_course_email_to_admin( $course_id, $user_id ) {
		$settings = $this->get_settings( 'finished_course', 'admin' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course = get_post( $course_id );
		$course_title = $course->post_title;
		$student_profile = get_edit_user_link( $student->ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . strip_tags( $settings['email_content'], '<br>' ) . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/finished-course-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $student_profile ],
			$body
		);
		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}
	public function finished_course_email_to_instructor( $course_id, $user_id ) {
		$settings = $this->get_settings( 'finished_course', 'instructor' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course = get_post( $course_id );
		$course_title = $course->post_title;
		$student_profile = get_edit_user_link( $student->ID );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\r\n\r\nIf" . strip_tags( $settings['email_content'], '<br>' ) . "\r\n\r\nIf" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/finished-course-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $student_profile ],
			$body
		);
		foreach ( Helper::get_instructors_email_by_course_id( $course_id ) as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}
	public function finished_course_email_to_student( $course_id, $user_id ) {
		$settings = $this->get_settings( 'finished_course', 'user' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course = get_post( $course_id );
		$course_title = $course->post_title;
		$permalink = get_permalink( $course_id );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/finished-course-user.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{course_url}' ],
			[ $user_display_name, $user_email, $course_title, $permalink ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function instructor_register_email_to_admin( $user_id ) {
		$settings = $this->get_settings( 'become_an_instructor', 'request' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/become-an-instructor-request.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{site_title}', '{site_url}', '{admin_instructor_manager}' ],
			[ $user_email, $site_name, $site_url, esc_url( admin_url( 'admin.php?page=academy-instructors' ) ) ],
			$body
		);
		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function instructor_register_email_to_instructor( $user_id ) {
		$settings = $this->get_settings( 'become_an_instructor', 'instructor' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/become-an-instructor-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{site_title}', '{site_url}', '{user_display_name}' ],
			[ $user_email, $site_name, $site_url, $user_display_name ],
			$body
		);

		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function become_an_instructor_accept( $user_id, $status ) {
		if ( 'approved' !== $status ) {
			return;
		}
		$settings = $this->get_settings( 'become_an_instructor', 'accept' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_email = $student->user_email;
		$user_display_name = $student->display_name;
		$login_url = $site_url . '/wp-login.php';
		$login_url = '<a href="' . $login_url . '">Login</a>';

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);

		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/become-an-instructor-accept.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{login_url}' ],
			[ $user_display_name, $site_name, $site_url, $login_url ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );

	}

	public function become_an_instructor_denied( $user_id, $status ) {
		if ( 'remove' !== $status ) {
			return;
		}
		$settings = $this->get_settings( 'become_an_instructor', 'denied' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/become-an-instructor-accept.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{site_title}', '{user_display_name}', '{site_url}' ],
			[ $site_name, $user_display_name, $site_url ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function student_register_email_to_admin( $user_id ) {
		$settings = $this->get_settings( 'student_registration', 'admin' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/student-registration-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{student_profile}' ],
			[ $user_email, $user_email, $user_display_name, $site_name, $site_url, $student_profile ],
			$body
		);
		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function student_register_email_to_student( $user_id ) {
		$settings = $this->get_settings( 'student_registration', 'student' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student            = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/student-registration-student.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{user_email}', '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_email, $user_email, $user_display_name, $site_name, $site_url ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function after_quiz_submit_to_admin( $quiz_data ) {
		$settings = $this->get_settings( 'quiz_submit', 'admin' );

		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student     = get_userdata( $quiz_data->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$course_title = get_the_title( $quiz_data->course_id );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . strip_tags( $settings['email_content'], '<br>' ) . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/quiz-submit-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{student_profile}', '{course_name}' ],
			[ $user_email, $user_display_name, $site_name, $site_url, $student_profile, $course_title ],
			$body
		);

		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function tutor_booked_email_to_admin( $booking_id, $booked_id, $user_id ) {
		$settings = $this->get_settings( 'tutor_booked', 'admin' );
		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$instructor_name = get_the_author_meta( 'display_name', get_post( $booking_id )->post_author );
		$session_time = get_post_meta( $booked_id, '_academy_booked_schedule_time', true );
		$location_or_meeting_link = get_post_meta( $booking_id, '_academy_booking_private_booked_info', true );
		$booking_created = get_post( $booked_id )->post_date;
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{tutor_name}' ],
			[ $user_display_name, $site_name, $site_url, get_the_title( $booking_id ) ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . strip_tags( $settings['email_content'], '<br>' ) . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/tutor-booked-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}
		$body = str_replace(
			[ '{student_name}', '{location_or_meeting_link}', '{instructor_name}', '{session_time}', '{booking_created_at}' ],
			[ $user_display_name, $location_or_meeting_link, $instructor_name, $session_time, $booking_created ],
			$body
		);
		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function tutor_booked_email_to_instructor( $booking_id, $booked_id, $user_id ) {
		$settings = $this->get_settings( 'tutor_booked', 'instructor' );
		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$instructor_name = get_the_author_meta( 'display_name', get_post( $booking_id )->post_author );
		$student_name = $student->display_name;
		$session_time = get_post_meta( $booked_id, '_academy_booked_schedule_time', true );
		$location_or_meeting_link = get_post_meta( $booking_id, '_academy_booking_private_booked_info', true );
		$dashboard = $site_url . '/dashboard/tutor-booking/booked/';
		$booking_created = get_post( $booked_id )->post_date;
		$subject = str_replace(
			[ '{instructor_name}', '{user_display_name}', '{site_url}', '{site_name}' ],
			[ $instructor_name, $user_display_name, $site_url, $site_name ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/tutor-booked-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}
		$body = str_replace(
			[ '{student_name}', '{session_time}', '{booking_created_at}', '{location_or_meeting_link}', '{instructor_dashboard}' ],
			[ $student_name, $session_time, $booking_created, $location_or_meeting_link, $dashboard ],
			$body
		);

		foreach ( Helper::get_instructor_email_by_booking_id( $booking_id ) as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function tutor_booked_email_to_student( $booking_id, $booked_id, $user_id ) {
		$settings = $this->get_settings( 'tutor_booked', 'student' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student     = get_userdata( $user_id );
		$student_name = $student->display_name;
		$instructor_name = get_the_author_meta( 'display_name', get_post( $booking_id )->post_author );
		$session_time = get_post_meta( $booked_id, '_academy_booked_schedule_time', true );
		$location_or_meeting_link = get_post_meta( $booking_id, '_academy_booking_private_booked_info', true );
		$subject = str_replace(
			[ '{student_name}' ],
			[ $student_name ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/tutor-booked-student.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}
		$body = str_replace(
			[ '{instructor_name}', '{session_time}', '{location_or_meeting_link}' ],
			[ $instructor_name, $session_time, $location_or_meeting_link ],
			$body
		);
		$this->mail->send_mail( $student->user_email ?? '', $subject, $body, $headers );
	}

	public function after_quiz_submit_to_instructor( $quiz_data ) {
		$settings = $this->get_settings( 'quiz_submit', 'instructor' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $quiz_data->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/quiz-submit-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{instructor_dashboard}', '{student_profile}' ],
			[ $user_email, $user_email, $user_display_name, $site_name, $site_url, $dashboard, $student_profile ],
			$body
		);

		foreach ( \Academy\Helper::get_instructors_by_course_id( $quiz_data->course_id ) as $instructor ) {
			$user = get_userdata( $instructor->ID );
			$this->mail->send_mail( $user->data->user_email, $subject, $body, $headers );
		}
	}

	public function after_quiz_attempt_manual_review_to_student( $quiz_data ) {
		$settings = $this->get_settings( 'quiz_evaluate', 'student' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $quiz_data['user_id'] );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course_url = get_permalink( $quiz_data['course_id'] );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/quiz-evaluate-student.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{course_url}' ],
			[ $user_email, $user_display_name, $site_name, $site_url, $course_url ],
			$body
		);

		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function after_assignment_submit_to_admin( $assignment ) {
		$settings = $this->get_settings( 'assignment_submit', 'admin' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $assignment->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/assignment-submit-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{student_profile}' ],
			[ $user_email, $user_email, $user_display_name, $site_name, $site_url, $student_profile ],
			$body
		);

		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function after_assignment_submit_to_instructor( $assignment ) {
		$settings = $this->get_settings( 'assignment_submit', 'instructor' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $assignment->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/assignment-submit-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{request_email}', '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{instructor_dashboard}', '{student_profile}' ],
			[ $user_email, $user_email, $user_display_name, $site_name, $site_url, $dashboard, $student_profile ],
			$body
		);

		foreach ( \Academy\Helper::get_instructors_by_course_id( $assignment->comment_parent ) as $instructor ) {
			$user = get_userdata( $instructor->ID );
			$this->mail->send_mail( $user->data->user_email, $subject, $body, $headers );
		}
	}

	public function after_assignment_evaluate_to_student( $assignment ) {
		$settings = $this->get_settings( 'assignment_evaluate', 'student' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $assignment->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course_url = get_the_permalink( $assignment->comment_post_ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/assignment-evaluate-student.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$achieve_mark = $assignment->meta['academy_pro_assignment_evaluate_point'];
		$total_mark = $assignment->academy_assignment_settings['total_points'];

		$body = str_replace(
			[ '{user_email}', '{user_display_name}', '{site_title}', '{site_url}', '{course_url}', '{achieve_mark}', '{total_mark}' ],
			[ $user_email, $user_display_name, $site_name, $site_url, $course_url, $achieve_mark, $total_mark ],
			$body
		);

		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function after_question_answer_submit_to_admin( $comment ) {
		$settings = $this->get_settings( 'question_submit', 'admin' );

		if ( ! $settings['is_enable'] ) {
			return;
		}
		$student     = get_userdata( $comment['author'] );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$course_title = get_the_title( $comment['post'] );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/question-submit-admin.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $student_profile ],
			$body
		);

		foreach ( Helper::get_users_email_by_role() as $email ) {
			$this->mail->send_mail( $email, $subject, $body, $headers );
		}
	}

	public function after_question_answer_submit_to_instructor( $comment ) {
		$settings = $this->get_settings( 'question_submit', 'instructor' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( $comment['author'] );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$course_title = get_the_title( $comment['post'] );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$student_profile = get_edit_user_link( $student->ID );
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/question-submit-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{course_name}', '{instructor_dashboard}', '{student_profile}' ],
			[ $user_display_name, $user_email, $course_title, $dashboard, $student_profile ],
			$body
		);

		if ( $settings['is_enable'] ) {
			$instructors = \Academy\Helper::get_instructors_by_course_id( $comment['post'] );
			foreach ( $instructors as $instructor ) {
				$user = get_userdata( $instructor->ID );
				$this->mail->send_mail( $user->data->user_email, $subject, $body, $headers );
			}
		}
	}

	public function after_question_answer_reply_to_student( $comment ) {
		$settings = $this->get_settings( 'question_reply', 'student' );

		if ( ! $settings['is_enable'] ) {
			return;
		}

		$student     = get_userdata( get_comment( $comment['parent'] )->user_id );
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$course_title = get_the_title( $comment['post'] );
		$user_display_name = $student->display_name;
		$user_email = $student->user_email;
		$course_url = \Academy\Helper::get_start_course_permalink( $comment['post'] );
		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}', '{course_name}' ],
			[ $user_display_name, $site_name, $site_url, $course_title ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/question-reply-student.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_email}', '{user_display_name}', '{course_name}', '{course_url}' ],
			[ $user_email, $user_display_name, $course_title, $course_url ],
			$body
		);

		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function after_withdraw_request_approved( $result ) {
		$settings = $this->get_settings( 'withdraw_request_approved', 'instructor' );
		if ( ! $settings['is_enable'] ) {
			return;
		}
		$method_type = json_decode( $result->method_data )->withdraw_method_type;
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $result->user_login;
		$request_status = $result->status;
		$user_email = $result->user_email;
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );
		$subject = str_replace(
			[ '{user_display_name}', '{user_email}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $user_email, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/withdraw-request-approved-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{instructor_dashboard}', '{request_status}', '{payment_method}' ],
			[ $user_display_name, $user_email, $dashboard, $request_status, $method_type ],
			$body
		);
		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}

	public function after_withdraw_request_rejected( $result ) {
		$settings = $this->get_settings( 'withdraw_request_rejected', 'instructor' );

		if ( ! $settings['is_enable'] ) {
			return;
		}
		$method_type = json_decode( $result->method_data )->withdraw_method_type;
		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );
		$user_display_name = $result->user_login;
		$request_status = $result->status;
		$user_email = $result->user_email;
		$dashboard = \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' );
		$subject = str_replace(
			[ '{user_display_name}', '{user_email}', '{site_title}', '{site_url}' ],
			[ $user_display_name, $user_email, $site_name, $site_url ],
			$settings['email_subject']
		);
		$footer = $this->get_global_setting( 'footer_text' );
		$email_type = $this->get_global_setting( 'email_content_type' );
		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/withdraw-request-rejected-instructor.php', array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}

		$body = str_replace(
			[ '{user_display_name}', '{user_email}', '{instructor_dashboard}', '{request_status}', '{payment_method}' ],
			[ $user_display_name, $user_email, $dashboard, $request_status, $method_type ],
			$body
		);

		$this->mail->send_mail( $user_email, $subject, $body, $headers );
	}
}
