<?php
namespace AcademyProEmail\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Settings {
	public static function get_settings_saved_data() {
		$settings = get_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME );
		if ( $settings ) {
			return json_decode( $settings, true );
		}
		return [];
	}
	public static function get_settings_default_data() {
		return apply_filters('academy_pro_email/admin/settings_default_data', [
			// general
			'form_name' => 'Academy LMS',
			'email_address' => get_option( 'admin_email' ),
			'email_content_type' => 'html',
			'header_image' => '',
			'footer_text' => '<!-- wp:heading --><h2 class="wp-block-heading"> Thank You </h2><!-- /wp:heading --><!-- wp:paragraph --><p>Academy LMS</p><!-- /wp:paragraph -->',
			// template
			'enrolled_course' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} enrolled in {course_name}',
					'email_heading' => 'Course enrollment completed. ',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> <strong>({user_email})</strong> has enrolled course <strong>{course_name}</strong> successfully </p><!-- /wp:paragraph -->',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} has enrolled course {course_name}',
					'email_heading' => 'User completed course enrolment',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> <strong>({user_email})</strong> has enrolled course <strong>{course_name}</strong> successfully </p><!-- /wp:paragraph -->',
				],
				'user' => [
					'is_enable' => true,
					'email_subject' => '{site_title} you have successfully enrolled course',
					'email_heading' => 'You have completed course enrollment',
					'email_content' => '<!-- wp:paragraph --><p>Congratulations! You have successfully enrolled in course <strong>{course_name}</strong></p><!-- /wp:paragraph -->',
				],
			],
			'finished_course' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} has completed a course ',
					'email_heading' => 'User Completed a course',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> <strong>({user_email})</strong> has completed a course <strong>{course_name}</strong> successfully</p><!-- /wp:paragraph -->',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} has finished course',
					'email_heading' => 'User Completed a course',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> <strong>({user_email})</strong> has completed a course <strong>{course_name}</strong> successfully</p><!-- /wp:paragraph -->',
				],
				'user' => [
					'is_enable' => true,
					'email_subject' => '{site_title} You have completed a course',
					'email_heading' => 'You have Completed a course ',
					'email_content' => '<!-- wp:paragraph --><p>Congrats! You have completed a course <strong>{course_name}</strong> successfully</p><!-- /wp:paragraph -->',
				],
			],
			'tutor_booked' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => 'Admin',
					'email_heading' => 'A new session has been scheduled',
					'email_content' => '<!-- wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student:</strong>{student_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Instructor:</strong>{instructor_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Date & Time:</strong>{session_time}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Location / Link:</strong>{location_or_meeting_link}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Created on:</strong>{booking_created_at}</li>
					<!-- /wp:list-item -->
					</ol>
					<!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>You can view and manage all bookings in the admin dashboard.</p>
					<!-- /wp:paragraph -->',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => 'Hello {instructor_name}',
					'email_heading' => 'A new session has been booked with you',
					'email_content' => '<!-- wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student:</strong>{student_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Date & Time:</strong>{session_time}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Location / Link:</strong>{location_or_meeting_link}</li>
					<!-- /wp:list-item -->
					</ol>
					<!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please ensure your availability and be prepared to start on time.  
						If you need to adjust the session, visit your instructor panel.
					</p>
					<!-- /wp:paragraph -->',

				],
				'student' => [
					'is_enable' => true,
					'email_subject' => 'Hi {student_name}',
					'email_heading' => 'Your session with {instructor_name} has been successfully booked!',
					'email_content' => '<!-- wp:paragraph -->
						<!-- wp:list {"ordered":true} -->
						<ol>
						<!-- wp:list-item -->
						<li><strong>Date & Time:</strong>{session_time}</li>
						<!-- /wp:list-item -->
						<!-- wp:list-item -->
						<li><strong>Location / Link:</strong>{location_or_meeting_link}</li>
						<!-- /wp:list-item -->
						</ol>
						<!-- /wp:list -->
						<!-- wp:paragraph -->
						<p>If you need to cancel, you can do so via in email to instructor.
						<!-- /wp:paragraph -->
						<!-- wp:paragraph -->
						We look forward to your productive session!.</p>
						<!-- /wp:paragraph -->',
				],
			],
			'become_an_instructor' => [
				'request' => [
					'is_enable' => true,
					'email_subject' => '{site_title} Request to become an instructor',
					'email_heading' => 'Work as an instructor',
					'email_content' => '<!-- wp:paragraph -->
						<p>User <strong>{request_email}</strong> has applied to work as an instructor at <strong>{site_title}</strong></p>        
						<p>Please login to <strong>{site_title}</strong> and access to <strong>{admin_instructor_manager}</strong> instructing to manage your application.</p>
					<!-- /wp:paragraph -->',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => 'Welcome to Our Learning Management System!',
					'email_heading' => 'Dear {user_display_name}',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Welcome to our Learning Management System (LMS)! We\'re excited to have you on board. Your registration is under review, please wait very soon we will inform you.</p>
					<!-- /wp:paragraph -->
					',
				],
				'accept' => [
					'is_enable' => true,
					'email_subject' => '{site_title} Your Application to become an instructor was accepted',
					'email_heading' => 'Become an instructor request accepted',
					'email_content' => '<!-- wp:paragraph --><p>Congratulations! Your request to become an Instructor was accepted. </p><p>Simply <strong>{login_url}</strong> to <strong>{site_title}</strong>  and begin instructing</p><!-- /wp:paragraph -->',
				],
				'denied' => [
					'is_enable' => true,
					'email_subject' => '{site_title} Your Application to become an instructor was rejected',
					'email_heading' => 'Become an instructor request rejected',
					'email_content' => '<!-- wp:paragraph --><p>Unfortunately, your request to become an Instructor at <strong>{site_title}</strong>, was rejected. Please try again later.</p><!-- /wp:paragraph -->',
				],
			],
			'assignment_submit' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => 'Assignment Submitted',
					'email_heading' => '{user_display_name} submitted an assignment',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Student submitted a new assignment.</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student Name:</strong>{user_display_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Email:</strong>{user_email}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Profile:</strong>{student_profile}</li>
					<!-- /wp:list-item -->
					</ol><!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please take any necessary steps to welcome them to our LMS and assist as needed.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>If you have questions or require more information, feel free to reach out.</p>
					<!-- /wp:paragraph -->
					',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => 'Assignment Submitted',
					'email_heading' => '{user_display_name} submitted an assignment',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Student submitted a new assignment.</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student Name:</strong>{user_display_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Email:</strong>{user_email}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Profile:</strong>{student_profile}</li>
					<!-- /wp:list-item -->
					</ol><!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please take any necessary steps to welcome them to our LMS and assist as needed.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>If you have questions or require more information, feel free to reach out.</p>
					<!-- /wp:paragraph -->
					',
				],
			],
			'assignment_evaluate' => [
				'student' => [
					'is_enable' => true,
					'email_subject' => 'Your assignment is evaluated !',
					'email_heading' => 'Dear {user_display_name}',
					'email_content' => '
					<!-- wp:paragraph -->
					<p><b>Dear {user_display_name}</b></p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Your Instructor evaluated your assignment. You have got <b>{achieve_mark}</b> out of <b>{total_mark}</b> .Please login to your account for more details.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Thanks for attend the assignment</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Best Regards<br/>Your Instructor</p>
					<!-- /wp:paragraph -->
					',
				],
			],
			'quiz_submit' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => 'Quiz Submitted',
					'email_heading' => '{user_display_name} submitted a quiz',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Student submitted a quiz.</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student Name:</strong>{user_display_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Email:</strong>{user_email}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Profile:</strong>{student_profile}</li>
					<!-- /wp:list-item -->
					</ol><!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please take any necessary steps to welcome them to our LMS and assist as needed.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>If you have questions or require more information, feel free to reach out.</p>
					<!-- /wp:paragraph -->
					',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => 'Quiz Submitted',
					'email_heading' => '{user_display_name} submitted a quiz',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Student submitted a quiz.</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student Name:</strong>{user_display_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Email:</strong>{user_email}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Profile:</strong>{student_profile}</li>
					<!-- /wp:list-item -->
					</ol><!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please take any necessary steps to welcome them to our LMS and assist as needed.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>If you have questions or require more information, feel free to reach out.</p>
					<!-- /wp:paragraph -->
					',
				],
			],
			'quiz_evaluate' => [
				'student' => [
					'is_enable' => true,
					'email_subject' => 'Your quiz manually evaluated !',
					'email_heading' => 'Dear {user_display_name}',
					'email_content' => '
					<!-- wp:paragraph -->
					<p><b>Dear {user_display_name}</b></p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Your Instructor evaluated your quiz manually. Please login to your account for more details.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Thanks for submit the quiz</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Best Regards<br/>Your Instructor</p>
					<!-- /wp:paragraph -->
					',
				],
			],
			'student_registration' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => 'New Student Registration',
					'email_heading' => '{user_display_name} has register as student',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>We have a new student on board:</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol>
					<!-- wp:list-item -->
					<li><strong>Student Name:</strong>{user_display_name}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Email:</strong>{user_email}</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li><strong>Student Profile:</strong>{student_profile}</li>
					<!-- /wp:list-item -->
					</ol><!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>Please take any necessary steps to welcome them to our LMS and assist as needed.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>If you have questions or require more information, feel free to reach out.</p>
					<!-- /wp:paragraph -->
					',
				],
				'student' => [
					'is_enable' => true,
					'email_subject' => 'Welcome to Our Learning Management System!',
					'email_heading' => 'Dear {user_display_name}',
					'email_content' => '
					<!-- wp:paragraph -->
					<p>Welcome to our Learning Management System (LMS)! We\'re excited to have you on board. Your registration is complete, and you now have access to a world of knowledge and learning resources.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Here\'s what to do next:</p>
					<!-- /wp:paragraph -->
					<!-- wp:list {"ordered":true} -->
					<ol><!-- wp:list-item -->
					<li>Log in to your account using the credentials you provided during registration.</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li>Explore your dashboard to find your enrolled courses.</li>
					<!-- /wp:list-item -->
					<!-- wp:list-item -->
					<li>Begin your learning journey at your own pace.</li>
					<!-- /wp:list-item --></ol>
					<!-- /wp:list -->
					<!-- wp:paragraph -->
					<p>If you have any questions or need assistance, please don\'t hesitate to reach out to our support team at {email_address}. We\'re here to help you every step of the way.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Let\'s embark on this educational adventure together! Enjoy your learning experience.</p>
					<!-- /wp:paragraph -->
					',
				],
			],
			'withdraw_request_approved' => [
				'instructor'  => [
					'is_enable' => true,
					'email_subject' => '{site_title} withdraw request has been approved',
					'email_heading' => 'Withdraw Request Approved!',
					'email_content' =>
					'<!-- wp:paragraph -->
					<p><b>Dear {user_display_name}</b></p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Your submitted withdraw request has been approved.</p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Best Regards<br/>Your Admin</p>
					<!-- /wp:paragraph -->',
				]
			],
			'withdraw_request_rejected' => [
				'instructor'  => [
					'is_enable' => true,
					'email_subject' => '{site_title} withdraw request has been rejected',
					'email_heading' => 'Withdraw Request Rejected!',
					'email_content' =>
					'<!-- wp:paragraph -->
					<p><b>Dear {user_display_name}</b></p>
					<!-- /wp:paragraph -->
					<!-- wp:paragraph -->
					<p>Your submitted withdraw request has been rejected.</p>
					<!-- /wp:paragraph -->',
				]
			],
			'question_submit' => [
				'admin' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} has submitted a question ',
					'email_heading' => 'New Student Submit a Question',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> has submitted a question in the course <strong>{course_name}</strong></p><!-- /wp:paragraph -->',
				],
				'instructor' => [
					'is_enable' => true,
					'email_subject' => '{user_display_name} has submitted a question',
					'email_heading' => 'New Student Submit a Question',
					'email_content' => '<!-- wp:paragraph --><p>User <strong>{user_display_name}</strong> has submitted a question in the course <strong>{course_name}</strong></p><!-- /wp:paragraph -->',
				],
			],
			'question_reply' => [
				'student' => [
					'is_enable' => true,
					'email_subject' => '{site_title} your question has been reply',
					'email_heading' => 'Your Question Has Been Reply!',
					'email_content' => '<!-- wp:paragraph --><p>Your submitted question has reply in the course <strong>{course_name}</strong></p><!-- /wp:paragraph -->',
				],
			],
			'email_verify' => [
				'is_enable' => (bool) \Academy\Helper::get_settings( 'required_register_email_verification' ),
				'email_subject' => 'Verify your email address',
				'email_heading' => 'Hello {user_display_name}',
				'email_content' => '<!-- wp:paragraph -->
				<p>Thank you for registering {site_url}</p>
				<!-- /wp:paragraph -->
				<!-- wp:paragraph -->
				<p>Please click on the link below to verify your email address:</p>
				<!-- /wp:paragraph -->
				<!-- wp:paragraph -->
				<p>{verify_email_link}</p>
				<!-- /wp:paragraph -->
				<!-- wp:paragraph -->
				<p>If you did not register on our site, please ignore this email.</p>
				<!-- /wp:paragraph -->',
			],
		]);
	}

	public static function save_settings( $form_data = false ) {
		$default_data = self::get_settings_default_data();
		$saved_data = self::get_settings_saved_data();
		$settings_data = wp_parse_args( $saved_data, $default_data );
		if ( $form_data ) {
			$settings_data = wp_parse_args( $form_data, $settings_data );
		}
		// if settings already saved, then update it
		if ( count( $saved_data ) ) {
			return update_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME, wp_json_encode( $settings_data ), false );
		}
		return add_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME, wp_json_encode( $settings_data ), '', false );
	}
}
