<?php
namespace AcademyProDeviceLoginRestrictions;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Helper {

	public static function get_browser_name() {

		if ( isset( $_SERVER['HTTP_USER_AGENT_CLIENT_HINT'] ) ) {
			$userAgentHints = json_decode( sanitize_text_field( wp_unslash( $_SERVER['HTTP_USER_AGENT_CLIENT_HINT'] ) ), true );
			if ( isset( $userAgentHints['brand'] ) ) {
				return sanitize_text_field( $userAgentHints['brand'] );
			}
		}

		$userAgent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) ) : '';

		$browser_name = 'Unknown';

		if ( strpos( $userAgent, 'MSIE' ) !== false || strpos( $userAgent, 'Trident' ) !== false ) {
			$browser_name = 'Internet Explorer';
		} elseif ( strpos( $userAgent, 'Edg' ) !== false ) {
			$browser_name = 'Edge';
		} elseif ( strpos( $userAgent, 'Chrome' ) !== false && strpos( $userAgent, 'Edg' ) === false ) {
			$browser_name = 'Google Chrome';
		} elseif ( strpos( $userAgent, 'Firefox' ) !== false ) {
			$browser_name = 'Mozilla Firefox';
		} elseif ( strpos( $userAgent, 'Safari' ) !== false && strpos( $userAgent, 'Chrome' ) === false ) {
			$browser_name = 'Apple Safari';
		} elseif ( strpos( $userAgent, 'Opera' ) !== false || strpos( $userAgent, 'OPR' ) !== false ) {
			$browser_name = 'Opera';
		}

		return $browser_name;
	}

	public static function get_platform() {
		$u_agent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) ) : '';

		$is_win     = is_numeric( strpos( $u_agent, 'Windows' ) );
		$is_android = is_numeric( strpos( $u_agent, 'Android' ) );
		$is_iphone  = is_numeric( strpos( $u_agent, 'Iphone' ) );
		$is_ipad    = is_numeric( strpos( $u_agent, 'Ipad' ) );
		$is_mac     = is_numeric( strpos( $u_agent, 'Mac' ) );
		$is_ios     = $is_iphone || $is_ipad;

		if ( $is_ios ) {
			$platform = 'iOS';
		} elseif ( $is_android ) {
			$platform = 'Android';
		} elseif ( $is_win ) {
			$platform = 'Windows';
		} elseif ( $is_mac ) {
			$platform = 'Mac';
		}

		return $platform;
	}

	public static function get_location( $user_ip = '' ) {
		if ( '' === $user_ip ) {
			$user_ip = isset( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : '';
		}

		$response = wp_remote_get( "http://ipinfo.io/{$user_ip}/json" );

		if ( is_wp_error( $response ) ) {
			return array(
				'country' => '',
				'city'    => '',
			);
		}

		$details = json_decode( wp_remote_retrieve_body( $response ) );

		$location = array(
			'country' => $details->country ?? '',
			'city'    => $details->city ?? '',
		);

		return $location;
	}

	public static function get_device_type() {
		$u_agent = isset( $_SERVER['HTTP_USER_AGENT'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_USER_AGENT'] ) ) : '';

		$device = 'Laptop';

		$is_mob = is_numeric( strpos( $u_agent, 'Mobile' ) );
		$is_tab = is_numeric( strpos( $u_agent, 'Tablet' ) );

		if ( $is_mob ) {
			$device = 'Mobile';
		} elseif ( $is_tab ) {
			$device = 'Tablet';
		}

		return $device;
	}

	public static function get_logged_in_devices( $user_id ) {
		global $wpdb;
		$key = Admin::$meta_key . '%';
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->usermeta} WHERE meta_key LIKE %s AND user_id = %d",
				$key,
				$user_id
			)
		);
	}
}
