<?php
if ( ! function_exists( 'academy_pro_manage_device_added_frontend_dashboard_menu' ) ) {
	function academy_pro_manage_device_added_frontend_dashboard_menu( $items ) {
		$user_id = get_current_user_id();
		$roles = (array) get_userdata( $user_id )->roles;
		if ( \Academy\Helper::get_settings( 'is_enable_device_login_restriction' ) ) {
			$items['manage-device'] = array(
				'label' => __( 'Manage Device', 'academy-pro' ),
				'icon' => 'academy-icon academy-icon--device-restrictions',
				'public' => ! current_user_can( 'manage_academy_instructor' ) && in_array( 'academy_student', $roles, true ) ? true : false,
				'priority' => 47,
			);
		}
		return $items;
	}
}

if ( ! function_exists( 'academy_pro_manage_frontend_dashboard_login_device_page' ) ) {
	function academy_pro_manage_frontend_dashboard_login_device_page() {
		$login_info = \AcademyProDeviceLoginRestrictions\Helper::get_logged_in_devices( get_current_user_id() );
		\AcademyPro\Helper::get_template(
			'frontend-dashboard/pages/manage-device.php',
			array(
				'login_info' => $login_info
			)
		);
	}
}
