<?php
namespace AcademyProCourseBundle;

use stdClass;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Helper {
	public static function get_bundle_enrolled( $bundle_id ) {
		$product_id = get_post_meta( $bundle_id, 'academy_course_bundle_product_id', true );
		$enrolled = 0;
		if ( ! empty( $product_id ) ) {
			$enrolled = self::count_enrolled_course_bundle( $product_id );
		}
		return $enrolled;
	}
	public static function get_max_students( $bundle_id ) {
		$course_ids   = self::get_bundle_courses( $bundle_id );
		$max_students = 0;
		if ( is_array( $course_ids ) ) {
			foreach ( $course_ids as $course_id ) {
				$max_students += (int) get_post_meta( $course_id, 'academy_course_max_students', true );
			}
		}
		return $max_students;
	}
	public static function get_bundle_duration( $bundle_id ) {
		$course_ids = self::get_bundle_courses( $bundle_id );
		$duration   = 0;

		if ( $course_ids ) {
			foreach ( $course_ids as $course_id ) {
				$duration += strtotime( \Academy\Helper::get_course_duration( $course_id ) );
			}
		}

		$duration = gmdate( 'H:i:s', $duration );
		return $duration;
	}
	public static function get_bundle_lessons( $bundle_id ) {
		$course_ids = self::get_bundle_courses( $bundle_id );
		$lessons = 0;
		if ( is_array( $course_ids ) ) {
			foreach ( $course_ids as $course_id ) {
				$lessons += (int) \Academy\Helper::get_total_number_of_course_lesson( $course_id );
			}
		}
		return $lessons;
	}
	public static function get_bundle_courses( $bundle_id ) {
		$course_ids = (array) get_post_meta( $bundle_id, 'academy_course_bundle_courses_ids', true );
		$course_ids = wp_list_pluck( $course_ids, 'value' );

		return $course_ids ? $course_ids : false;
	}
	public static function product_belongs_with_bundle( $product_id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$query = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM 	{$wpdb->postmeta} WHERE	meta_key = %s  AND meta_value = %d  limit 1",
				'academy_course_bundle_product_id',
				$product_id
			)
		);

		return $query;
	}
	public static function product_belongs_with_course_bundle( $product_id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$query = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM 	{$wpdb->postmeta} WHERE	meta_key = %s  AND meta_value = %d  limit 1",
				'academy_course_bundle_product_id',
				$product_id
			)
		);

		return $query;
	}
	public static function get_bundle_product_id( $bundle_id ) {
		$product_id = absint( get_post_meta( $bundle_id, 'academy_course_bundle_product_id', true ) );
		return apply_filters( 'academy_pro/course_bundle/get_course_bundle_product_id', $product_id, $bundle_id );
	}
	public static function get_bundle_courses_id( $bundle_id ) {
		$course_ids = (array) get_post_meta( $bundle_id, 'academy_course_bundle_courses_ids', true );
		return apply_filters( 'academy_pro/course_bundle/get_course_bundle_courses_id', $course_ids, $bundle_id );
	}
	public static function is_bundle_fully_booked( $bundle_id ) {
		$total_enrolled = self::get_bundle_enrolled( $bundle_id );
		$max_students   = self::get_max_students( $bundle_id );

		return ( $total_enrolled > 0 ) && ( $max_students > 0 ) && ( $total_enrolled >= $max_students );
	}
	public static function get_order_by_customer_id_and_product_id( $customer_id, $product_id ) {
		global $wpdb;
		$order = [];
		if ( 'yes' === get_option( 'woocommerce_custom_orders_table_enabled' ) ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$order = $wpdb->get_row(
				$wpdb->prepare(
					"SELECT
						orders.id,
						SUBSTRING_INDEX(orders.status, 'wc-', -1) AS status,
						orders.billing_email,
						orders.date_created_gmt,
						orders.date_updated_gmt
					FROM
						{$wpdb->prefix}wc_orders AS orders
					INNER JOIN
						{$wpdb->prefix}wc_order_product_lookup AS lookup
					ON
						orders.id = lookup.order_id
					WHERE
						orders.customer_id = %d
					AND
						lookup.product_id = %d",
					$customer_id,
					$product_id
				)
			);
		} else {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$order = $wpdb->get_row(
				$wpdb->prepare(
					"SELECT
						orders.ID,
						orders.post_author,
						SUBSTRING_INDEX(orders.post_status, 'wc-', -1) AS status,
						orders.post_date_gmt AS date
					FROM
						{$wpdb->prefix}posts orders 
					INNER JOIN
						{$wpdb->prefix}woocommerce_order_items as items
					ON
						orders.id = items.order_id
					AND
						items.order_item_type = 'line_item'
					INNER JOIN
						{$wpdb->prefix}woocommerce_order_itemmeta as meta
					ON
						items.order_item_id = meta.order_item_id
					AND
						meta.meta_key = '_product_id'
					AND
						meta.meta_value = %d
					WHERE
						orders.post_type = 'shop_order'
					AND
						orders.post_author = %d",
					$product_id,
					$customer_id
				)
			);
		}//end if

		return $order;
	}

	public static function count_enrolled_course_bundle( $product_id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$enrolled_ids = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT COUNT(*) 
				FROM (
				SELECT DISTINCT opl.order_id 
				FROM {$wpdb->prefix}wc_order_product_lookup AS opl
				INNER JOIN {$wpdb->prefix}wc_orders AS o 
				ON opl.order_id = o.id
				WHERE opl.product_id = %d
				AND o.status = %s
				) AS subquery;",
				$product_id, 'wc-completed'
			)
		);
		return (int) $enrolled_ids;
	}
}
