<?php
namespace  AcademyProCertificates;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Hooks {
	public static function init() {
		$self = new self();
		add_filter( 'academy_certificates/template_dynamic_codes', [ $self, 'add_template_dynamic_codes' ] );
		add_filter( 'academy_certificates/template_dynamic_codes_variables', [ $self, 'add_template_dynamic_codes_variables' ], 10, 3 );
		add_filter( 'academy_certificates/certificate_template_id', [ $self, 'update_certificate_template_id' ], 10, 2 );
	}

	public function add_template_dynamic_codes( $codes ) {
		$codes[] = '{{verification_id}}';
		return $codes;
	}

	public function add_template_dynamic_codes_variables( $variables, $student_id, $course_id ) {
		$verification_id = Helper::get_certificate_verification_hash_by_course_and_student_id( $student_id, $course_id );
		$variables[] = $verification_id;
		return $variables;
	}

	public function update_certificate_template_id( $template_id, $course_id ) {
		$course_certificate_id = get_post_meta( $course_id, 'academy_course_certificate_id', true );
		if ( ! empty( $course_certificate_id ) ) {
			return $course_certificate_id;
		}
		return $template_id;
	}

}
