<?php

namespace AcademyProCalendar\Frontend;

use AcademyPro\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Calender {

	public static function init(): void {
		$instance = new self();
		add_action( 'academy_frontend_dashboard_calendar_endpoint', [ $instance, 'dashboard_page' ] );
		add_filter( 'academy/frontend_dashboard_menu_items', [ $instance, 'dashboard_menu' ], 10, 1 );
	}

	public function dashboard_page() : void {
		Helper::get_template(
			'frontend-dashboard/pages/calendar.php',
			[]
		);
	}

	public function dashboard_menu( array $menu ) : array {
		$menu['calendar'] = array(
			'label' => __( 'Event Calendar', 'academy-pro' ),
			'icon'  => 'academy-icon academy-icon--calendar',
			'public' => true,
			'priority' => 27,
		);
		return $menu;
	}
}
