<?php
namespace AcademyProCalendar;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use AcademyProCalendar\Ajax\EventData;
use Academy\Interfaces\AddonInterface;

final class Calendar implements AddonInterface {
	private $addon_name = 'calendar';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_CALENDAR_VERSION', '1.0' );
		define( 'ACADEMY_PRO_CALENDAR_VERSION_NAME', 'academy_pro_calendar_version' );
		define( 'ACADEMY_PRO_CALENDAR_DIR_PATH', ACADEMY_PRO_ADDONS_DIR_PATH . 'calendar/' );
	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		Frontend\EnqueScripts::init();
		Frontend\Calender::init();
		EventData::init();
	}


	public function addon_activation_hook() {

	}
}
