<?php
namespace AcademyProBuddypress;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;
use Exception;
use AcademyProBuddypress\Activities\CourseActivity;
use Academy\Admin\Notices;


final class Buddypress implements AddonInterface {
	private $addon_name = 'buddypress';


	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}


	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}


	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_BUDDYPRESS_VERSION', '1.0' );
	}


	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addons
		if (
			! \Academy\Helper::get_addon_active_status( $this->addon_name ) ||
			! self::is_active_buddypress() ||
			self::is_active_buddyboss()
		) {
			return;
		}

		add_action( 'init', [ __CLASS__, 'load' ] );
	}

	public function addon_activation_hook() {
	}

	public static function load() {

		if ( ! function_exists( 'bp_is_active' ) ) {
			return;
		}

		// check BuddyPress Group & Actitivity activated or not
		if ( ! bp_is_active( 'activity' ) || ! bp_is_active( 'groups' ) ) {
			Notices::add_notice('buddypress-groups-and-activity-needs-to-be-activated', [
				'type'          => 'danger',
				'message'       => esc_html__( 'BuddyPress Activity stream & Group is not activated yet.', 'academy-pro' ),
				'button_text'   => __( 'Go Settings', 'academy-pro' ),
				'button_action' => esc_url( admin_url( 'options-general.php?page=bp-components' ) )
			]);

			// Buddypress is not properly configured, doesnt need to load inegration file
			return;
		}

		GroupSettings::init();
		Configaration::init();
		ActivityRegistration::init();
	}
	public static function is_active_buddypress() : bool {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		return is_plugin_active( 'buddypress/bp-loader.php' );
	}

	public static function is_active_buddyboss() : bool {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		return is_plugin_active( 'buddyboss-platform-release/bp-loader.php' );
	}
}
