<?php
namespace AcademyProBuddypress\Activities;

use AcademyProBuddypress\ActivityRegistration;
use AcademyProBuddypress\Helpers\Activity;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class QuestionAndAnswerActivity {

	public static function init(): void {

		$instance = new self();

		/** Track  User Question Activity */
		add_action(
			'academy/frontend/insert_course_qa',
			[ $instance, 'user_question' ],
			10, 1
		);

		/** Track Question Answer Activity */
		add_action(
			'academy/frontend/insert_course_qa_answered',
			[ $instance, 'question_answer' ],
			10, 1
		);

	}

	public function user_question( array $question ): void {
		$groups = ActivityRegistration::get_assigned_groups( $question['post'] );
		if (
			empty( $question ) ||
			! isset( $question['_post'] ) ||
			! isset( $question['author'] ) ||
			! isset( $question['content'] ) ||
			! isset( $question['post'] ) ||
			empty( $groups )
		) {
			return;
		}

		$course_permalink = $question['_post']['permalink'];
		$course_title = $question['_post']['title'];

		$data = [];
		$data['user_id']   = $question['author'];
		$data['course_id'] = $question['post'] ?? null;

		$data['action'] = sprintf(
			'<a href="%s">%s</a>',
			esc_url( $course_permalink ),
			esc_html( $course_title )
		);

		$data['content'] = sprintf(
			'<h3><a href="%s"> A question has been posted by %s @%s </a></h3>
            <blockquote>%s</blockquote>',
			esc_url( $course_permalink ),
			esc_html( $question['author_name'] ),
			esc_html( $course_title ),
			esc_html( $question['content']['rendered'] )
		);

		$activity = new Activity( $groups, 'user_question', $data );

		$activity->post();

	}


	public function question_answer( array $answer ): void {
		$groups = ActivityRegistration::get_assigned_groups( $answer['post'] );
		if (
			empty( $answer ) ||
			! isset( $answer['_post'] ) ||
			! isset( $answer['author'] ) ||
			! isset( $answer['content'] ) ||
			! isset( $answer['parent'] ) ||
			! isset( $answer['post'] ) ||
			empty( $groups )
		) {
			return;
		}

		$question = $answer['parent'] ? get_comment( $answer['parent'] ) : null;

		$course_permalink = $answer['_post']['permalink'];
		$course_title     = $answer['_post']['title'];

		$data = [];

		$data['user_id']   = $question ? $question->author : '';
		$data['course_id'] = $question ? $question->comment_post_ID : '';
		$data['action'] = sprintf(
			'<a href="%s">%s</a>',
			esc_url( $course_permalink ),
			esc_html( $course_title )
		);
		if ( $question ? $question->user_id : '' === $answer['author'] ) {
			$data['content'] = sprintf(
				'<h3><a href="%s"> %s has replied at his/her comment</a></h3>
                <blockquote>%s</blockquote>',
				esc_url( $course_permalink ),
				esc_html( $answer['author_name'] ),
				esc_html( $answer['content']['rendered'] )
			);
		} else {
			$data['content'] = sprintf(
				'<h3><a href="%s"> A question from %s has been answered by %s @%s </a></h3>
                <h4>Question</h4>
                <p>%s</p>
                <h4>Answer</h4>
                <blockquote>%s</blockquote>',
				esc_url( $course_permalink ),
				esc_html( $question ? $question->comment_author : '' ),
				esc_html( $answer['author_name'] ),
				esc_html( $course_title ),
				esc_html( $question ? $question->comment_content : '' ),
				esc_html( $answer['content']['rendered'] )
			);
		}//end if

		$activity = new Activity( $groups, 'user_question', $data );

		$activity->post();

	}
}
