<?php
namespace AcademyProBuddyboss;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class GroupSettings {

	protected $settings_key = 'buddyboss_group_activities';

	protected $allowed_fields = [
		'course_enrollment'    => 'Course Enrollment',
		'course_complete'      => 'Course Complete',
		'course_announcements' => 'Course Announcements',
		'user_question'        => 'User Question',
		'question_answer'      => 'Question Answer',
		'lession_update'       => 'Lession Update',
		'quiz_start'           => 'Quiz Start',
		'quiz_end'             => 'Quiz End',
	];

	public static function init() : void {

		$instance = new self();

		// permission check
		if (
			! current_user_can( 'manage_options' )
		) {
			return;
		}

		// add activity settings section on admin group edit page
		add_action('bp_groups_admin_meta_boxes', [
			$instance,
			'add_settings_meta'
		]);

		add_action('bp_group_admin_edit_after', [
			$instance,
			'save_settings'
		]);

		// add activity settings section at frontend group creation page
		add_action('bp_after_group_settings_creation_step', [
			$instance,
			'add_settings_section_on_group_creation'
		]);

		add_action('groups_create_group_step_save_group-settings', [
			$instance,
			'save_settings_on_group_creation'
		]);

		// add activity settings section at frontend group settings
		add_action('bp_after_group_settings_admin', [
			$instance,
			'add_settings_section_on_group_creation'
		]);

		add_action('groups_group_settings_edited', [
			$instance,
			'save_settings_on_group_creation'
		]);
	}

	public function save_settings_on_group_creation() : void {
		$group_id = bp_get_current_group_id();
		if ( empty( $group_id ) ) {
			$group_id = buddyboss()->groups->new_group_id;
		}
		$this->save_settings( $group_id );
	}


	public function add_settings_section_on_group_creation() {
		?>
		<fieldset>
			<legend><?php esc_html_e( 'Academy LMS Activity Settings', 'academy-pro' ); ?></legend>
			<?php $this->settings_fields( bp_get_current_group_id() ); ?>
		</fieldset>
		<?php
	}


	public function add_settings_meta() : void {
		add_meta_box(
			'academy-lms-buddyboss-integration',
			__( 'Academy LMS Activity Settings', 'academy-pro' ),
			[ $this, 'add_settings_fields' ],
			get_current_screen()->id,
			'side',
			'core'
		);
	}

	public function add_settings_fields( $group_data = false ) : void {

		if ( ! $group_data ) {
			return;
		}

		$this->settings_fields( $group_data->id );
	}

	public function settings_fields( $id = false ) : void {

		$data = groups_get_groupmeta( $id, $this->settings_key );

		if ( empty( $data ) ) {
			$data = [];
		}

		wp_nonce_field(
			'academy_buddyboss_integration_settings_save_' . $id,
			'academy_buddyboss_integration_nonce'
		);
		?>
		<ul style="list-style-type:none;">
		<?php $i = 1; foreach ( $this->allowed_fields as $key => $value ) : ?>
			<li>
				<label for="<?php echo esc_attr( $this->settings_key . '-' . $i ); ?>">
					<input 
						type="checkbox" 
						name="<?php echo esc_attr( $this->settings_key ); ?>[]" 
						id="<?php echo esc_attr( $this->settings_key . '-' . $i ); ?>"
						value="<?php echo esc_attr( $key ); ?>"
						<?php echo in_array( $key, $data ) ? 'checked' : '';// phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict ?>>
						<?php echo esc_attr( $value ); ?>
				</label>
			</li>
			<?php $i++;
endforeach; ?>
		</ul>
		<?php

	}


	public function save_settings( $group_id ) : void {

		if (
			! current_user_can( 'manage_options' ) ||
			empty( $group_id ) ||
			// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
			strtoupper( sanitize_text_field( wp_unslash( $_SERVER['REQUEST_METHOD'] ) ) ) !== 'POST' ||
			! isset( $_POST['academy_buddyboss_integration_nonce'] ) ||
			! wp_verify_nonce(
				sanitize_text_field( sanitize_text_field( wp_unslash( $_POST['academy_buddyboss_integration_nonce'] ) ) ),
				'academy_buddyboss_integration_settings_save_' . $group_id
			)
		) {
			return;
		}

		$data = [];
		foreach ( array_keys( $this->allowed_fields ) as $key ) {
			// phpcs:ignore WordPress.PHP.StrictInArray.MissingTrueStrict
			if ( in_array( $key, $_POST[ $this->settings_key ] ?? [] ) ) {
				$data[] = $key;
			}
		}

		groups_update_groupmeta( $group_id, $this->settings_key, $data );

	}
}
