<?php
namespace AcademyProBuddyboss;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;
use Academy\Admin\Notices;


final class Buddyboss implements AddonInterface {
	private $addon_name = 'buddyboss';


	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}


	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}


	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_BUDDYBOSS_VERSION', '1.0' );
	}



	public function init_addon() {
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addons
		if (
			! \Academy\Helper::get_addon_active_status( $this->addon_name ) ||
			! self::is_active_buddyboss()
		) {
			return;
		}

		add_action( 'init', [ __CLASS__, 'load' ] );
	}


	public function addon_activation_hook() {
	}

	public static function load() {

		if ( ! function_exists( 'bp_is_active' ) ) {
			return;
		}

		if ( ! bp_is_active( 'activity' ) || ! bp_is_active( 'groups' ) ) {
			Notices::add_notice('buddyboss-groups-and-activity-needs-to-be-activated', [
				'type'          => 'danger',
				'message'       => esc_html__( 'Buddyboss Activity stream & Group is not activated yet.', 'academy-pro' ),
				'button_text'   => __( 'Go Settings', 'academy-pro' ),
				'button_action' => esc_url( admin_url( 'admin.php?page=bp-components' ) )
			]);

			// return if not properly configured
			return;
		}

		GroupSettings::init();
		Configaration::init();
		ActivityRegistration::init();
	}

	public static function is_active_buddyboss() : bool {
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		return is_plugin_active( 'buddyboss-platform-release/bp-loader.php' ) ||
			is_plugin_active( 'buddyboss-platform/bp-loader.php' );
	}
}
