<?php
/**
 * Plugin Name: WooCommerce Vehicle Parts Finder - Make/Model/Year/Engine/Category/Keyword
 * Description: A plugin to find Vehicles or Vehicle Parts on the website based on Make/Model/Year/Engine/Category/Keyword.
 * Version: 3.7
 * Author: The WP Instinct Team
 * Author URI: http://wpinstinct.com/
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WOO_Vehicle_Parts_Finder' ) ) :

/**
 * Main WOO_Vehicle_Parts_Finder Class
 *
 * @class WOO_Vehicle_Parts_Finder
 */
final class WOO_Vehicle_Parts_Finder {
	
	/**
	 * @var string
	 */
	public $version = '3.7';

	/**
	 * @var WOO_Vehicle_Parts_Finder The single instance of the class
	 */
	protected static $_instance = null;

	/**
	 * Main WOO_Vehicle_Parts_Finder Instance
	 *
	 * Ensures only one instance of WOO_Vehicle_Parts_Finder is loaded or can be loaded
	 *
	 * @see WOO_VPF()
	 * @return Main instance
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * WOO_Vehicle_Parts_Finder Constructor
	 * @access public
	 */
	public function __construct() {
	
		// Return if WooCommerce plugin is not activate
		if( ! function_exists( 'is_plugin_active' ) ) {
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		
		if( ! (
			in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) )
			||
			is_plugin_active( 'woocommerce/woocommerce.php' )
			||
			is_plugin_active_for_network( 'woocommerce/woocommerce.php' )
		) ) {
			return;
		}

		// Define constants
		$this->define_constants();
		
		// Include required files
		$this->includes();

		// Hooks
		add_action( 'init', array( $this, 'init' ), 0 );
		add_filter( 'plugin_action_links_' . WOO_VPF_PLUGIN_BASENAME, array( $this, 'plugin_action_links' ) );
	}


	/**
	 * Define WOO_VPF Constants
	 */
	private function define_constants() {
		define( 'WOO_VPF_PLUGIN_FILE', __FILE__ );
		define( 'WOO_VPF_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WOO_VPF_PLUGIN_VERSION', $this->version );
		define( 'WOO_VPF_PLUGIN_URL', $this->plugin_url() );
		define( 'WOO_VPF_PLUGIN_PATH', $this->plugin_path() );
		define( 'WOO_VPF_TEXT_DOMAIN', 'woo_vpf' );
	}
	
	/**
	 * Include required core files
	 */
	private function includes() {
		include_once( 'includes/woo-vpf-cookies.php' );
		include_once( 'includes/class-woo-vpf-functions.php' );
		include_once( 'includes/class-woo-vpf-hooks.php' );
		include_once( 'includes/admin/class-woo-vpf-taxonomies.php' );
		include_once( 'includes/admin/class-woo-vpf-widget-filter.php' );
		include_once( 'includes/admin/class-woo-vpf-shortcode-filter.php' );
		include_once( 'includes/class-woo-vpf-my-vehicles.php' );
		include_once( 'includes/class-woo-vpf-ajax.php' );
		
		if( !is_admin() ) {
			include_once( 'includes/class-woo-vpf-frontend.php' );
		}
		
		if( is_admin() ) {
			include_once( 'includes/admin/class-woo-vpf-admin.php' );
			include_once( 'includes/admin/class-woo-vpf-admin-actions.php' );
			include_once( 'includes/admin/class-woo-vpf-admin-menu.php' );
			include_once( 'includes/admin/class-woo-vpf-settings.php' );
			include_once( 'includes/admin/class-woo-vpf-post-types.php' );
			include_once( 'includes/admin/class-woo-vpf-taxonomy-terms-list.php' );
			include_once( 'includes/admin/class-woo-vpf-taxonomy-metabox-template.php' );
			include_once( 'includes/admin/class-woo-vpf-importers.php' );
		}
	}
	
	/**
	 * Load Localisation files
	 */
	public function load_plugin_textdomain() {
		load_plugin_textdomain( 'woo_vpf', false, plugin_basename( dirname( __FILE__ ) ) . "/i18n/languages" );
	}

	/**
	 * Get the plugin url
	 *
	 * @return string
	 */
	public function plugin_url() {
		return untrailingslashit( plugins_url( '/', __FILE__ ) );
	}
	
	/**
	 * Get the plugin path
	 *
	 * @return string
	 */
	public function plugin_path() {
		return untrailingslashit( plugin_dir_path( __FILE__ ) );
	}

	/**
	 * Init Cards when WordPress Initialises
	 */
	public function init() {
		$this->load_plugin_textdomain();		
		do_action( 'woo_vpf_init' );
	}
	
	/**
	 * Show action links on the plugin screen.
	 *
	 * @param	mixed $links Plugin Action links
	 * @return	array
	 */
	public function plugin_action_links( $links ) {
		$action_links = array(
			'settings' => '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=woo_vpf' ) . '" title="' . esc_attr( __( 'View Settings', WOO_VPF_TEXT_DOMAIN ) ) . '">' . __( 'Settings', WOO_VPF_TEXT_DOMAIN ) . '</a>',
		);

		return array_merge( $action_links, $links );
	}

}

endif;

/**
 * Returns the main instance of WOO_Vehicle_Parts_Finder to prevent the need to use globals
 *
 * @return WOO_Vehicle_Parts_Finder
 */

function WOO_VPF() {
	return WOO_Vehicle_Parts_Finder::instance();
}

// Global for backwards compatibility.
$GLOBALS['woo_vpf'] = WOO_VPF();
