<?php
/**
 * Cookies Manager
 */

defined ( 'ABSPATH' ) || exit;

/**
 * Set Cookie
 */
function vpf_set_cookie ( $identifier = '', $item = '', $type = ''/*, $sub_identifier = ''*/ ) { // $type is for array $item only
	if ( empty ( $identifier ) ) {
		return;
	}
	
	$expiry = 0;
	
	//setcookie ( 'vpf', '', time() - 3600, COOKIEPATH ? COOKIEPATH : '/', COOKIE_DOMAIN ); exit;
	
	$vpf = array ();
	
	if ( isset ( $_COOKIE['vpf'] ) ) {
		$vpf = vpf_get_cookie ();
		
		if ( empty ( $vpf ) || ! is_array ( $vpf ) ) {
			$vpf = array ();
		}
	}
	
	if ( $type != '' ) { // append or delete
		if ( ! isset ( $vpf[ $identifier ] ) || empty ( $vpf[ $identifier ] ) ) {
			$vpf[ $identifier ] = array ();
		}
		
		// Delete Item for Reset Latest Item on Top
		if ( ! empty ( $vpf[ $identifier ] ) && in_array ( $item, $vpf[ $identifier ] ) ) {
			$item_key = array_search ( $item, $vpf[ $identifier ] );
			
			if ( $item_key !== false ) {
				unset ( $vpf[ $identifier ][ $item_key ] );
			}
		}
		
		if ( $type == 'append' && ! empty ( $item ) ) {
			$vpf[ $identifier ][] = $item;
		}
		
		// Reset Array Keys from Zero
		if ( ! empty ( $vpf[ $identifier ] ) ) {
			$vpf[ $identifier ] = array_values ( $vpf[ $identifier ] );
		}
	} else {
		if ( empty ( $item ) ) {
			$expiry	= time() - 3600;
		}
		
		$vpf[ $identifier ] = $item;
	}
	
	$vpf = maybe_serialize ( $vpf );
	setcookie ( 'vpf', $vpf, $expiry, COOKIEPATH ? COOKIEPATH : '/', COOKIE_DOMAIN );
	$_COOKIE['vpf'] = $vpf;
}

/**
 * Get Cookie
 */
function vpf_get_cookie ( $identifier = '' ) {
	$vpf = '';
	
	if ( isset ( $_COOKIE['vpf'] ) && ! empty ( $_COOKIE['vpf'] ) ) {
		$vpf = maybe_unserialize ( wp_unslash ( $_COOKIE['vpf'] ) );
		
		if ( ! empty ( $identifier ) ) {
			$vpf = isset ( $vpf[ $identifier ] ) ? $vpf[ $identifier ] : '';
		}
	}
	
	return $vpf;
}