<?php
/**
 * Common Functions
 *
 * @class WOO_VPF_Functions
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WOO_VPF_Functions {
	
	/**
	 * Check if VPF search results page
	 *
	 * @return void
	 */
	public static function is_search() {
		if( isset($_REQUEST['action']) && $_REQUEST['action'] == 'vpf-search' ) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * Get Make Label
	 *
	 * @return string/html
	 */
	public static function get_make_label() {
		$woo_vpf_make_label = WC_Admin_Settings::get_option( 'woo_vpf_make_label' );
		if( $woo_vpf_make_label == '' ) {
			$woo_vpf_make_label = __( 'Make', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_make_label', $woo_vpf_make_label );
	}
	
	/**
	 * Get Model Label
	 *
	 * @return string/html
	 */
	public static function get_model_label() {
		$woo_vpf_model_label = WC_Admin_Settings::get_option( 'woo_vpf_model_label' );
		if( $woo_vpf_model_label == '' ) {
			$woo_vpf_model_label = __( 'Model', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_model_label', $woo_vpf_model_label );
	}
	
	/**
	 * Get Year Label
	 *
	 * @return string/html
	 */
	public static function get_year_label() {
		$woo_vpf_year_label = WC_Admin_Settings::get_option( 'woo_vpf_year_label' );
		if( $woo_vpf_year_label == '' ) {
			$woo_vpf_year_label = __( 'Year', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_year_label', $woo_vpf_year_label );
	}
	
	/**
	 * Get Engine Label
	 *
	 * @return string/html
	 */
	public static function get_engine_label() {
		$woo_vpf_engine_label = WC_Admin_Settings::get_option( 'woo_vpf_engine_label' );
		if( $woo_vpf_engine_label == '' ) {
			$woo_vpf_engine_label = __( 'Engine', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_engine_label', $woo_vpf_engine_label );
	}
	
	/**
	 * Get Category Label
	 *
	 * @return string/html
	 */
	public static function get_category_label() {
		$woo_vpf_category_label = WC_Admin_Settings::get_option( 'woo_vpf_category_label' );
		if( $woo_vpf_category_label == '' ) {
			$woo_vpf_category_label = __( 'Category', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_category_label', $woo_vpf_category_label );
	}
	
	/**
	 * Get Keyword Label
	 *
	 * @return string/html
	 */
	public static function get_keyword_label() {
		$woo_vpf_keyword_label = WC_Admin_Settings::get_option( 'woo_vpf_keyword_label' );
		if( $woo_vpf_keyword_label == '' ) {
			$woo_vpf_keyword_label = __( 'Keyword', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_keyword_label', $woo_vpf_keyword_label );
	}
	
	/**
	 * Get Search Results Label
	 *
	 * @return string/html
	 */
	public static function get_search_results_label() {
		$woo_vpf_search_results_label = WC_Admin_Settings::get_option( 'woo_vpf_search_results_label' );
		if( $woo_vpf_search_results_label == '' ) {
			$woo_vpf_search_results_label = __( 'Search Results For:', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_search_results_label', $woo_vpf_search_results_label );
	}
	
	/**
	 * My Vehicles - Is Activated?
	 *
	 * @return boolean
	 */
	public static function is_activate_my_vehicles() {
		$woo_vpf_activate_my_vehicles = WC_Admin_Settings::get_option( 'woo_vpf_activate_my_vehicles' );
		if( $woo_vpf_activate_my_vehicles != 'yes' ) {
			$woo_vpf_activate_my_vehicles = 'no';
		}
		
		return apply_filters( 'woo_vpf_activate_my_vehicles', $woo_vpf_activate_my_vehicles );
	}
	
	/**
	 * My Vehicles - Title
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_title() {
		$woo_vpf_my_vehicles_title = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_title' );
		return apply_filters( 'woo_vpf_my_vehicles_title', $woo_vpf_my_vehicles_title );
	}
	
	/**
	 * My Vehicles - Saved Vehicles Limit
	 *
	 * @return number
	 */
	public static function get_my_vehicles_save_limit() {
		$woo_vpf_my_vehicles_save_limit = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_save_limit' );
		$woo_vpf_my_vehicles_save_limit = ( int ) $woo_vpf_my_vehicles_save_limit;
		if( ! $woo_vpf_my_vehicles_save_limit ) {
			$woo_vpf_my_vehicles_save_limit = 5;
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_save_limit', $woo_vpf_my_vehicles_save_limit );
	}
	
	/**
	 * My Vehicles - Saved Vehicles Title
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_save_title() {
		$woo_vpf_my_vehicles_save_title = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_save_title' );
		if( $woo_vpf_my_vehicles_save_title == '' ) {
			$woo_vpf_my_vehicles_save_title = __( 'My Saved Vehicles', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_save_title', $woo_vpf_my_vehicles_save_title );
	}
	
	/**
	 * My Vehicles - Saved Vehicles Description
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_save_description() {
		$woo_vpf_my_vehicles_save_description = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_save_description' );
		if( $woo_vpf_my_vehicles_save_description == '' ) {
			//$woo_vpf_my_vehicles_save_description = __( 'View, manage and find parts', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_save_description', $woo_vpf_my_vehicles_save_description );
	}
	
	/**
	 * My Vehicles - Saved Vehicles No Items Text
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_save_no_item_text() {
		$woo_vpf_my_vehicles_save_no_item_text = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_save_no_item_text' );
		if( $woo_vpf_my_vehicles_save_no_item_text == '' ) {
			//$woo_vpf_my_vehicles_save_no_item_text = __( 'You are yet to start saving search results', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_save_no_item_text', $woo_vpf_my_vehicles_save_no_item_text );
	}
	
	/**
	 * My Vehicles - Saved Vehicles Clear History Text
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_save_clear_history_text() {
		$woo_vpf_my_vehicles_save_clear_history_text = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_save_clear_history_text' );
		if( $woo_vpf_my_vehicles_save_clear_history_text == '' ) {
			$woo_vpf_my_vehicles_save_clear_history_text = __( 'Clear History', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_save_clear_history_text', $woo_vpf_my_vehicles_save_clear_history_text );
	}
	
	/**
	 * My Vehicles - Vehicles History Limit
	 *
	 * @return number
	 */
	public static function get_my_vehicles_history_limit() {
		$woo_vpf_my_vehicles_history_limit = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_history_limit' );
		$woo_vpf_my_vehicles_history_limit = ( int ) $woo_vpf_my_vehicles_history_limit;
		if( ! $woo_vpf_my_vehicles_history_limit ) {
			$woo_vpf_my_vehicles_history_limit = 5;
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_history_limit', $woo_vpf_my_vehicles_history_limit );
	}
	
	/**
	 * My Vehicles - Vehicles History Title
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_history_title() {
		$woo_vpf_my_vehicles_history_title = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_history_title' );
		if( $woo_vpf_my_vehicles_history_title == '' ) {
			$woo_vpf_my_vehicles_history_title = __( 'Vehicles History', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_history_title', $woo_vpf_my_vehicles_history_title );
	}
	
	/**
	 * My Vehicles - Vehicles History Description
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_history_description() {
		$woo_vpf_my_vehicles_history_description = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_history_description' );
		if( $woo_vpf_my_vehicles_history_description == '' ) {
			//$woo_vpf_my_vehicles_history_description = __( 'Easily navigate the latest vehicles selected', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_history_description', $woo_vpf_my_vehicles_history_description );
	}
	
	/**
	 * My Vehicles - Vehicles History No Items Text
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_history_no_item_text() {
		$woo_vpf_my_vehicles_history_no_item_text = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_history_no_item_text' );
		if( $woo_vpf_my_vehicles_history_no_item_text == '' ) {
			//$woo_vpf_my_vehicles_history_no_item_text = __( 'You are yet to start searching vehicles', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_history_no_item_text', $woo_vpf_my_vehicles_history_no_item_text );
	}
	
	/**
	 * My Vehicles - Vehicles History Clear History Text
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_history_clear_history_text() {
		$woo_vpf_my_vehicles_history_clear_history_text = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_history_clear_history_text' );
		if( $woo_vpf_my_vehicles_history_clear_history_text == '' ) {
			$woo_vpf_my_vehicles_history_clear_history_text = __( 'Clear History', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_history_clear_history_text', $woo_vpf_my_vehicles_history_clear_history_text );
	}
	
	/**
	 * My Vehicles - Add Vehicle Text
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_add_vehicle_text() {
		$woo_vpf_my_vehicles_add_vehicle_text = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_add_vehicle_text' );
		if( $woo_vpf_my_vehicles_add_vehicle_text == '' ) {
			$woo_vpf_my_vehicles_add_vehicle_text = __( 'Add a Vehicle', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_add_vehicle_text', $woo_vpf_my_vehicles_add_vehicle_text );
	}
	
	/**
	 * My Vehicles - Add Vehicle Heading
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_add_vehicle_heading() {
		$woo_vpf_my_vehicles_add_vehicle_heading = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_add_vehicle_heading' );
		if( $woo_vpf_my_vehicles_add_vehicle_heading == '' ) {
			$woo_vpf_my_vehicles_add_vehicle_heading = __( 'Select Vehicle', WOO_VPF_TEXT_DOMAIN );
		}
		
		return apply_filters( 'woo_vpf_my_vehicles_add_vehicle_heading', $woo_vpf_my_vehicles_add_vehicle_heading );
	}
	
	/**
	 * My Vehicles - Add Vehicle Description
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_add_vehicle_description() {
		$woo_vpf_my_vehicles_add_vehicle_description = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_add_vehicle_description' );
		return apply_filters( 'woo_vpf_my_vehicles_add_vehicle_description', $woo_vpf_my_vehicles_add_vehicle_description );
	}
	
	/**
	 * My Vehicles - Add Vehicle Shortcode
	 *
	 * @return string/html
	 */
	public static function get_my_vehicles_add_vehicle_shortcode() {
		$woo_vpf_my_vehicles_add_vehicle_shortcode = WC_Admin_Settings::get_option( 'woo_vpf_my_vehicles_add_vehicle_shortcode' );
		return apply_filters( 'woo_vpf_my_vehicles_add_vehicle_shortcode', $woo_vpf_my_vehicles_add_vehicle_shortcode );
	}
	
	/**
	 * Get Post Terms Hierarchy
	 *
	 * @return array
	 */
	public static function wp_get_post_terms_hierarchy( $post_ID ) {
		$vpf_terms = array();
		
		$makes = array();
		$models = array();
		$years = array();
		$engines = array();
		
		$terms = wp_get_post_terms ( $post_ID, 'product_make', apply_filters ( 'woo_vpf_post_terms_hierarchy_args', array( 'fields' => 'all', 'orderby' => 'parent', 'order' => 'ASC' ) ) );
		if ( ! empty ( $terms ) ) {
			usort ( $terms, array ( __CLASS__, 'sort_post_terms_by_parent' ) );
			
			// Makes
			foreach( $terms as $k=>$term ) {
				if( $term->parent != 0 ) {
					continue;
				}
				
				$make_id = $term->term_id;
				
				$makes[ $make_id ] = $term;
				$vpf_terms['makes'][ $make_id ]['term'] = $term;
				unset( $terms[$k] );
			}
			
			// Models
			foreach( $terms as $k=>$term ) {
				$make_id = $term->parent;
				if( isset( $makes[ $make_id ] ) ) {
					$model_id = $term->term_id;
					
					$models[ $model_id ] = $term;
					$vpf_terms['makes'][ $make_id ]['models'][ $model_id ]['term'] = $term;
					unset( $terms[$k] );
				}
			}
			
			// Years
			foreach( $terms as $k=>$term ) {
				$model_id = $term->parent;
				if( isset( $models[ $model_id ] ) ) {
					$year_id = $term->term_id;
					$make_id = $models[ $model_id ]->parent;
					
					$years[ $year_id ] = $term;
					$vpf_terms['makes'][ $make_id ]['models'][ $model_id ]['years'][ $year_id ]['term'] = $term;
					unset( $terms[$k] );
				}
			}
			
			// Engines
			foreach( $terms as $k=>$term ) {
				$year_id = $term->parent;
				if( isset( $years[ $year_id ] ) ) {
					$engine_id = $term->term_id;
					$model_id = $years[ $year_id ]->parent;
					$make_id = $models[ $model_id ]->parent;
					
					$engines[ $engine_id ] = $term;
					$vpf_terms['makes'][ $make_id ]['models'][ $model_id ]['years'][ $year_id ]['engines'][ $engine_id ]['term'] = $term;
					unset( $terms[$k] );
				}
			}
		}
		
		return apply_filters( 'woo_vpf_post_terms_hierarchy', array( $vpf_terms, $makes, $models, $years, $engines ) );
	}
	
	/**
	 * Sort Terms by Parent
	 */
	public static function sort_post_terms_by_parent ( $a, $b ) {
		return $a->parent - $b->parent;
	}
	
	/**
	 * Sort Terms
	 *
	 * @param  array $terms
	 * @return array $terms
	 */
	public static function sort_terms( $terms='' ) {
		if( empty( $terms ) ) {
			return $terms;
		}
		
		$sort_makes = array();
		$sort_models = array();
		$sort_years = array();
		$sort_engines = array();
		
		foreach( $terms as $key => $term ) {
			$sort_makes[ $key ] = is_array( $term['make'] ) ? $term['make']['name'] : $term['make'];
			$sort_models[ $key ] = is_array( $term['model'] ) ? $term['model']['name'] : $term['model'];
			$sort_years[ $key ] = is_array( $term['year'] ) ? $term['year']['name'] : $term['year'];

			if( isset( $term['engine'] ) ) {
				$sort_engines[ $key ] = is_array( $term['engine'] ) ? $term['engine']['name'] : $term['engine'];
			}
		}

		if( isset( $term['engine'] ) ) {
			array_multisort( $sort_makes, SORT_ASC, $sort_models, SORT_ASC, $sort_years, SORT_ASC, $sort_engines, SORT_ASC, $terms );
		} else {
			array_multisort( $sort_makes, SORT_ASC, $sort_models, SORT_ASC, $sort_years, SORT_ASC, $terms );
		}
		
		return $terms;
	}
	
	/**
	 * Arrange Terms by Year Range
	 *
	 * @param  array $terms
	 * @return array $terms
	 */
	public static function arrange_terms_by_year_range( $terms='' ) {
		if( empty( $terms ) ) {
			return $terms;
		}
		
		$yearly_terms = array();
		foreach( $terms as $term ) {
			$term = array_filter( $term );
			
			if ( ! isset ( $term['year'] ) ) {
				continue;
			}
			
			$year = $term['year'];
			unset( $term['year'] );
			
			$yearly_terms[ $year ][] = implode( '{-VPF-SEPARATOR-}', $term );
		}
		
		if ( empty ( $yearly_terms ) ) {
			return $terms;
		}
		
		ksort( $yearly_terms );
		
		$terms = array();
		foreach( $yearly_terms as $year=>&$year_terms ) {
			if( ! empty( $year_terms ) ) {
				foreach( $year_terms as $key=>$year_term ) {
					if( ! empty( $year_term ) ) {
						$year_current = $year;
						$year_start = $year_current;
						$year_end = $year_start;
						
						if( (int) $year_current == $year_current ) { // Check if numeric year
							while( $year_current ) {
								$year_current++;
								
								$year_current_key = false;
								if( isset( $yearly_terms[ $year_current ] ) ) {
									$year_current_key = array_search( $year_term, $yearly_terms[ $year_current ] );
								}

								if( $year_current_key !== false ) {
									$year_end = $year_current;
									unset( $yearly_terms[ $year_current ][ $year_current_key ] );
								} else {
									break;
								}
							}
						}
						
						$term = array();
						$year_term = explode( '{-VPF-SEPARATOR-}', $year_term );
						
						if( $year_end > $year_start ) {
							$term['year'] = $year_start . ' - ' . $year_end;
						} else {
							$term['year'] = $year_start;
						}
						
						if( isset( $year_term[0] ) ) {
							$term['make'] = $year_term[0];
						} else {
							$term['make'] = '';
						}
						
						if( isset( $year_term[1] ) ) {
							$term['model'] = $year_term[1];
						} else {
							$term['model'] = '';
						}
						
						if( isset( $year_term[2] ) ) {
							$term['engine'] = $year_term[2];
						} else {
							$term['engine'] = '';
						}
						
						$terms[] = $term;
					}
				}
			}
		}
		
		return $terms;
	}
	
	/**
	 * Get Terms List
	 *
	 * @param  int $parent
	 * @return string/html
	 */
	public static function get_terms_list( $parent=0, $selected='', $panel='' ) {
		if( $parent === '' ) {
			return;
		}
		
		$order = 'ASC';
		
		if( $parent ) {
			$woo_vpf_years_sort_order = WC_Admin_Settings::get_option( 'woo_vpf_years_sort_order' );
			if( $woo_vpf_years_sort_order == 'desc' ) {
				$ancestors = get_ancestors( $parent, 'product_make' );
				
				if( count( $ancestors ) === 1 ) {
					$order = 'DESC';
				}
			}
		}
		
		$product_terms = get_terms( 'product_make', apply_filters( 'woo_vpf_terms_args', array(
			'orderby'		=> 'name',
			'order'			=> $order,
			'parent'		=> $parent,
			'hide_empty'	=> false,
			'ignore_parent'	=> true
		) ) );
		
		if( !empty( $product_terms ) ) {
			$woo_vpf_show_empty_terms = WC_Admin_Settings::get_option( 'woo_vpf_show_empty_terms' );
			
			foreach( $product_terms as $product_term ) {
				if( $woo_vpf_show_empty_terms != 'yes' && $panel == 'front' && ! $product_term->count ) {
					continue;
				}
				
				?><option value="<?php echo $product_term->term_id; ?>" <?php if( $selected == $product_term->term_id ) { echo 'selected'; } ?>><?php echo $product_term->name; ?></option><?php
			}
		}
	}
	
	/**
	 * Get Categories
	 *
	 * @param  int $parent_id
	 * @param  int $level
	 * @return string/html
	 */
	public static function get_categories_list( $parent_id=0, $level=0, $selected='' ) {
		$woo_vpf_included_categories = WC_Admin_Settings::get_option( 'woo_vpf_included_categories' );
		
		if( ! empty( $woo_vpf_included_categories ) ) {
			$args = array(
				'orderby'		=> 'name',
				'order'			=> 'ASC',
				'include'		=> $woo_vpf_included_categories,
				'hide_empty'	=> 0
			);
		} else {
			$args = array(
				'orderby'		=> 'name',
				'order'			=> 'ASC',
				'parent'		=> $parent_id,
				'hide_empty'	=> 0
			);
		}
		
		$product_categories = get_terms( 'product_cat', apply_filters( 'woo_vpf_category_args', $args ) );
		
		if( !empty($product_categories) ) {
			
			if( ! empty( $woo_vpf_included_categories ) ) {
				foreach( $product_categories as $product_category ) {
					$child_prefix = '';
				
					/* if( $product_category->parent > 0 ) {
						$parent_terms = self::get_parent_terms( $product_category->term_id );
						unset( $parent_terms[0] );
					
						if( ! empty( $parent_terms ) ) {
							$parent_terms = array_reverse( $parent_terms );
						
							foreach( $parent_terms as $key => $parent_term ) {
								$term = get_term_by( 'id', $parent_term, 'product_make' );
								$child_prefix = $term->name . ' > ';
							}
						}
					} */
				
					?><option value="<?php echo $product_category->term_id; ?>" <?php if( $selected == $product_category->term_id ) { echo 'selected'; } ?>><?php echo $child_prefix . $product_category->name; ?></option><?php
				}
			} else {
				$level = $level + 1;
			
				$child_prefix = str_pad( '', ( $level-1 ), "-", STR_PAD_LEFT );
				if( !empty($child_prefix) ) {
					$child_prefix = '&nbsp;' . $child_prefix . '&nbsp;';
				}
			
				foreach( $product_categories as $product_category ) {
					?><option value="<?php echo $product_category->term_id; ?>" <?php if( $selected == $product_category->term_id ) { echo 'selected'; } ?>><?php echo $child_prefix . $product_category->name; ?></option><?php
					self::get_categories_list( $product_category->term_id, $level, $selected );
				}
			}
		}
	}
	
	/**
	 * WOO_VPF Filter Box
	 *
	 * @param  array $args
	 * @return string/html
	 */
	public static function get_filter_widget_template( $args ) {
		$make_label		= WOO_VPF_Functions::get_make_label ();
		$model_label	= WOO_VPF_Functions::get_model_label ();
		$year_label		= WOO_VPF_Functions::get_year_label ();
		$engine_label	= WOO_VPF_Functions::get_engine_label ();
		$category_label	= WOO_VPF_Functions::get_category_label ();
		
		$args = shortcode_atts( array(
			'title'			=> __( 'Vehicle Parts Filter', WOO_VPF_TEXT_DOMAIN ),
			'view'			=> 'V',
			'label_make'	=> sprintf( __( 'Select %s', WOO_VPF_TEXT_DOMAIN ), $make_label ),
			'label_model'	=> sprintf( __( 'Select %s', WOO_VPF_TEXT_DOMAIN ), $model_label ),
			'show_year'		=> '1',
			'label_year'	=> sprintf( __( 'Select %s', WOO_VPF_TEXT_DOMAIN ), $year_label ),
			'show_engine'	=> '',
			'label_engine'	=> sprintf( __( 'Select %s', WOO_VPF_TEXT_DOMAIN ), $engine_label ),
			'show_category'	=> '',
			'label_category'=> sprintf( __( 'Select %s', WOO_VPF_TEXT_DOMAIN ), $category_label ),
			'show_keyword'	=> '1',
			'label_keyword'	=> __( 'Product Name', WOO_VPF_TEXT_DOMAIN ),
			'show_my_vehicles'	=> '',
			'label_search'	=> __( 'Search', WOO_VPF_TEXT_DOMAIN ),
			'label_reset_search'	=> __( 'Reset Search', WOO_VPF_TEXT_DOMAIN ),
		), $args );
		
		$search = vpf_get_cookie ( 'search' );
		
		?><div class="widget-woo-vpf-filter <?php echo ( ( $args['view'] == 'H' ) ? 'woo-vpf-filter-horizontal': 'woo-vpf-filter-vertical'); ?>">
		
			<?php do_action( 'woo_vpf_before_filter_widget', $args ); ?>
			
			<form action="<?php echo apply_filters ( 'woo_vpf_filter_form_action', esc_url( home_url( '/' ) ) ); ?>" method="get">
			
				<?php do_action( 'woo_vpf_after_filter_form_start', $args ); ?>
				
				<div class="woo-vpf-field woo-vpf-field-make">
					<?php $label_make = apply_filters( 'widget_woo_vpf_label_make', $args['label_make'], $args ); ?>
					
					<select name="make">
						<option value=""><?php echo $label_make; ?></option>
						<?php
							$make = '';
							if( isset( $_REQUEST['make'] ) ) {
								$make = $_REQUEST['make'];
							} else if( ! empty ( $search ) && isset( $search['make'] ) ) {
								$make = $search['make'];
							}
							
							self::get_terms_list( 0, $make, 'front' );
						?>
					</select>
				</div>
				
				<div class="woo-vpf-field woo-vpf-field-model">
					<?php $label_model = apply_filters( 'widget_woo_vpf_label_model', $args['label_model'], $args ); ?>
					
					<select name="model">
						<option value=""><?php echo $label_model; ?></option>
						<?php
							if( isset( $make ) && $make > 0 ) {
								
								$model = '';
								if( isset( $_REQUEST['model'] ) ) {
									$model = $_REQUEST['model'];
								} else if( ! empty ( $search ) && isset( $search['model'] ) ) {
									$model = $search['model'];
								}
								
								self::get_terms_list( $make, $model, 'front' );
							}
						?>
					</select>
				</div>
				
				<?php
					if( $args['show_year'] == 1 || $args['show_year'] === "true" ) {
						?><div class="woo-vpf-field woo-vpf-field-year">
							<?php $label_year = apply_filters( 'widget_woo_vpf_label_year', $args['label_year'], $args ); ?>
					
							<select name="year_id">
								<option value=""><?php echo $label_year; ?></option>
								<?php
									if( isset( $model ) && $model > 0 ) {
								
										$year_id = '';
										if( isset( $_REQUEST['year_id'] ) ) {
											$year_id = $_REQUEST['year_id'];
										} else if( ! empty ( $search ) && isset( $search['year_id'] ) ) {
											$year_id = $search['year_id'];
										}
							
										self::get_terms_list( $model, $year_id, 'front' );
									}
								?>
							</select>
						</div><?php
						
						if( $args['show_engine'] == 1 || $args['show_engine'] === "true" ) {
							?><div class="woo-vpf-field woo-vpf-field-engine">
								<?php $label_engine = apply_filters( 'widget_woo_vpf_label_engine', $args['label_engine'], $args ); ?>
							
								<select name="engine">
									<option value=""><?php echo $label_engine; ?></option>
									<?php
										if( isset( $year_id ) && $year_id > 0 ) {
										
											$engine = '';
											if( isset( $_REQUEST['engine'] ) ) {
												$engine = $_REQUEST['engine'];
											} else if( ! empty ( $search ) && isset( $search['engine'] ) ) {
												$engine = $search['engine'];
											}
								
											self::get_terms_list( $year_id, $engine, 'front' );
										}
									?>
								</select>
							</div><?php
						}
					}
				?>
				
				<?php
					if( $args['show_category'] == 1 || $args['show_category'] === "true" ) {
						?><div class="woo-vpf-field woo-vpf-field-category">
							<?php $label_category = apply_filters( 'widget_woo_vpf_label_category', $args['label_category'], $args ); ?>
							<select name="category">
								<option value=""><?php echo $label_category; ?></option>
								<?php
									$category = '';
									if( isset($_REQUEST['category']) ) {
										$category = $_REQUEST['category'];
									} else if( ! empty ( $search ) && isset( $search['category'] ) ) {
										$category = $search['category'];
									}
									
									self::get_categories_list( 0, 0, $category );
								?>
							</select>
						</div><?php
					}
				?>
				
				<?php
					if( $args['show_keyword'] == 1 || $args['show_keyword'] === "true" ) {
						?><div class="woo-vpf-field woo-vpf-field-keyword">
							<?php $label_keyword = apply_filters( 'widget_woo_vpf_label_keyword', $args['label_keyword'], $args ); ?>
							<input type="text" name="s" value="<?php echo ( isset( $_REQUEST['s'] ) ? trim( stripslashes( $_REQUEST['s'] ) ) : '' ); ?>" placeholder="<?php echo $label_keyword; ?>" />
						</div><?php
					}
				?>
				
				<div class="woo-vpf-field woo-vpf-field-submit">
					
					<?php if ( apply_filters ( 'woo_vpf_filter_post_type', true ) ) { ?>
						<input type="hidden" name="post_type" value="product" />
					<?php } ?>
					
					<input type="hidden" name="action" value="vpf-search" />
					<?php do_action( 'wpml_add_language_form_field' ); ?>
					
					<?php
						// Add Lang Param in URL
						if( self::is_wpml_activated() ) {
							do_action( 'wpml_add_language_form_field' );
						}
					?>
					
					<?php $label_search = apply_filters( 'widget_woo_vpf_label_search', $args['label_search'], $args ); ?>
					<input type="submit" value="<?php echo $label_search; ?>" />
					
					<?php
						$woo_vpf_activate_remember_search = WC_Admin_Settings::get_option( 'woo_vpf_activate_remember_search' );
						if( $woo_vpf_activate_remember_search == 'yes' ) {
							if( ! empty ( $search ) && isset( $search['term_id'] ) ) {
								$label_reset_search = apply_filters( 'widget_woo_vpf_label_reset_search', $args['label_reset_search'], $args );
								
								// On Reset, Go to URL
								$refresh_url = '#';
								if( self::is_search() ) {
									$shop_page_id = wc_get_page_id( 'shop' );
									
									if ( $shop_page_id > 0 ) {
										$refresh_url = get_permalink( $shop_page_id );
									} else {
										$refresh_url = home_url();
									}
								}
									
								echo '<a class="woo-vpf-reset-search" href="'.$refresh_url.'">' . $label_reset_search . '</a>';
							}
						}
					?>
				</div>
				
				<?php do_action( 'woo_vpf_before_filter_form_end', $args ); ?>
				
				<div class="woo-vpf-clearfix"></div>
			</form>
			
			<?php do_action( 'woo_vpf_after_filter_widget', $args ); ?>
			
		</div><?php
	}
	
	/**
	 * Get Ancestor Terms Hierarchy
	 *
	 * @param  int $term_id
	 * @param  array $parent_terms

	 * @return array
	 */
	public static function get_parent_terms_hierarchy( $term_id ) {
		if( $term_id > 0 ) {
			$parent_terms = self::get_parent_terms( $term_id );
			
			if( ! empty( $parent_terms ) ) {
				$parent_term_keys = array( 'make', 'model', 'year', 'engine' );
				
				$parent_terms = array_reverse( $parent_terms );
				$parent_terms = array_pad( $parent_terms, sizeof( $parent_term_keys ), '' );				
				$parent_terms = array_combine( $parent_term_keys, $parent_terms );				
				$parent_terms = array_filter( $parent_terms );
				
				foreach( $parent_terms as $key => $parent_term ) {
					$term = get_term_by( 'id', $parent_term, 'product_make' );
					$parent_terms[ $key ] = array(
						'id'	=> $term->term_id,
						'name'	=> $term->name
					);
				}
			}
		
			return $parent_terms;
		}
	}
	
	/**
	 * Get Ancestor Terms
	 *
	 * @param  int $term_id
	 * @param  array $parent_terms
	 * @return array
	 */
	public static function get_parent_terms( $term_id, $parent_terms=array() ) {
		if( $term_id > 0 ) {
			$parent_terms[] = $term_id;
			
			$term = get_term_by( 'id', $term_id, 'product_make' );
			if( $term->parent > 0 ) {
				$parent_terms = self::get_parent_terms( $term->parent, $parent_terms );
			}
		}
		
		return $parent_terms;
	}
	
	/**
	 * Format Name to Remove Extra Spaces
	 *
	 * @param  int $string
	 * @return string
	 */
	public static function format_string( $string ) {
		if( ! empty( $string ) ) {
			$string = utf8_encode( $string );
			return trim( preg_replace( '!\s+!', ' ', $string ) );
		}
	}
	
	/**
	 * Check if term already exists
	 *
	 * @param  int $name
	 * @param  int $parent
	 * @return int $term_id
	 */
	public static function term_exists( $name, $parent=0 ) {
		$term_id = '';
		
		if( ! empty( $name ) ) {
			$term = term_exists ( $name, 'product_make', ( int ) $parent );
			
			if ( empty ( $term ) and ! is_wp_error ( $term ) ) {
				$term = term_exists ( htmlspecialchars ( $name ), 'product_make', ( int ) $parent );
			}
			
			if ( ! empty ( $term ) and ! is_wp_error ( $term ) ) {
				$term_id = $term['term_id'];
			}
		}
		
		return $term_id;
	}
	
	/**
	 * Insert term in database
	 *
	 * @param  int $name
	 * @param  int $parent
	 * @return int $term_id
	 */
	public static function insert_term( $name, $parent=0 ) {
		if ( '' == trim( $name ) ) {
			return new WP_Error( 'empty_term_name', __( 'A name is required for this term', WOO_VPF_TEXT_DOMAIN ) );
		}
		
		$term = wp_insert_term( $name, 'product_make', array( 'parent' => $parent ) );
		
		if ( ! empty ( $term ) && ! is_wp_error( $term ) ) {
			$term = $term['term_id'];
		}
		
		return $term;
	}
	
	/**
	 * Update term in database
	 *
	 * @param  int $term_id
	 * @param  int $name
	 * @param  int $parent
	 * @return int $term_id
	 */
	public static function update_term( $term_id, $name, $parent=0 ) {
		if ( '' == trim( $name ) ) {
			return new WP_Error( 'empty_term_name', __( 'A name is required for this term', WOO_VPF_TEXT_DOMAIN ) );
		}
		
		global $wpdb;
		
		$wpdb->update( $wpdb->terms, array( 'name' => $name ), array( 'term_id' => $term_id ) );
		$wpdb->update( $wpdb->term_taxonomy, array( 'parent' => $parent ), array( 'term_id' => $term_id ) );
		
		return $term_id;
	}
	
	/**
	 * WPML: Is Activated?
	 *
	 * @return void
	 */
	public static function is_wpml_activated() {
		if( function_exists('icl_object_id') ) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * Product Terms List Table
	 */
	public static function product_terms_list ( $post_id = false ) {
		$include_meta_data		= true;

		if ( $post_id ) {
			$include_meta_data	= false;
		}
		
		if ( ! $post_id && is_product () ) {
			global $post;
			$post_id = $post->ID;
		}
		
		if ( ! $post_id ) {
			return;
		}
		
		$post_terms	= wp_get_post_terms ( $post_id, 'product_make', apply_filters ( 'woo_vpf_post_terms_hierarchy_args', array( 'fields' => 'ids', 'orderby' => 'parent', 'order' => 'ASC', 'parent' => 0, 'number' => 1 ) ) );
		
		if ( empty ( $post_terms ) ) {
			return;
		}
		
		$woo_vpf_activate_tab_engines	= WC_Admin_Settings::get_option ( 'woo_vpf_activate_tab_engines' );
		
		$make_label		= WOO_VPF_Functions::get_make_label ();
		$model_label	= WOO_VPF_Functions::get_model_label ();
		$year_label		= WOO_VPF_Functions::get_year_label ();
		$engine_label	= WOO_VPF_Functions::get_engine_label ();
		
		?><div class="woo-vpf-product-tab">
			
			<?php
				if ( $include_meta_data ) {
					do_action ( 'woo_vpf_product_tab_before_content' );
					
						$woo_vpf_tab_heading = WC_Admin_Settings::get_option ( 'woo_vpf_tab_heading' );
						if ( $woo_vpf_tab_heading != '' ) {
							echo apply_filters ( 'woo_vpf_tab_heading_before', '<h2>' ) . $woo_vpf_tab_heading . apply_filters ( 'woo_vpf_tab_heading_after', '</h2>' );
						}
					
						$woo_vpf_tab_description = WC_Admin_Settings::get_option ( 'woo_vpf_tab_description' );
						if ( $woo_vpf_tab_description != '' ) {
							echo apply_filters ( 'woo_vpf_tab_description_before', '<p>' ) . $woo_vpf_tab_description . apply_filters ( 'woo_vpf_tab_description_after', '</p>' );
						}
						
					do_action ( 'woo_vpf_product_tab_after_content' );
				}
			?>
			
			<?php do_action ( 'woo_vpf_product_tab_before_list' ); ?>
			
				<?php $woo_vpf_tab_ajax	= WC_Admin_Settings::get_option ( 'woo_vpf_tab_ajax' ); ?>
			
				<table class="woo-vpf-product-terms-list-table" border="0" <?php if ( $woo_vpf_tab_ajax == 'yes' ) { echo 'data-post-id="' . $post_id . '"'; } ?>>
					<thead>
						<tr>
							<th><?php echo $make_label; ?></th>
							<th><?php echo $model_label; ?></th>
							<th><?php echo $year_label; ?></th>
							
							<?php
								if ( $woo_vpf_activate_tab_engines == 'yes' ) {
									?><th><?php echo $engine_label; ?></th><?php
								}
							?>
						</tr>
					</thead>
					
					<tfoot>
						<tr>
							<th><?php echo $make_label; ?></th>
							<th><?php echo $model_label; ?></th>
							<th><?php echo $year_label; ?></th>
							
							<?php
								if ( $woo_vpf_activate_tab_engines == 'yes' ) {
									?><th><?php echo $engine_label; ?></th><?php
								}
							?>
						</tr>
					</tfoot>
					
					<tbody>
						<?php
							if ( $woo_vpf_tab_ajax == 'yes' ) {
								$woo_vpf_tab_ajax_loading_text	= WC_Admin_Settings::get_option ( 'woo_vpf_tab_ajax_loading_text' );
								
								?><tr>
									<td colspan="<?php echo ( ( $woo_vpf_activate_tab_engines == 'yes' ) ? 4 : 3 ); ?>" class="woo-vpf-product-terms-loading">
										<?php echo $woo_vpf_tab_ajax_loading_text; ?>
									</td>
								</tr><?php
							} else {
								self::get_product_tab_terms_list_table_rows ( $post_id );
							}
						?>
					</tbody>
				</table>
			
			<?php do_action ( 'woo_vpf_product_tab_after_list' ); ?>
			
		</div><?php
	}
	
	/**
	 * Get Product Tab Terms Rows
	 */
	public static function get_product_tab_terms_list_table_rows ( $post_id = false ) {
		if ( ! $post_id ) {
			return;
		}
		
		list ( $post_terms, $years, $makes, $models, $engines )	= WOO_VPF_Functions::wp_get_post_terms_hierarchy ( $post_id );
		if ( empty ( $post_terms ) ) {
			return;
		}
		
		if ( isset ( $post_terms['makes'] ) && ! empty ( $post_terms['makes'] ) ) {
			$terms = array ();
			$i = 0;
				
			$vpf_makes = $post_terms['makes'];
			foreach ( $vpf_makes as $vpf_make ) {
				$make_name = $vpf_make['term']->name;
				
				if ( isset ( $vpf_make['models'] ) && ! empty ( $vpf_make['models'] ) ) {
					$vpf_models = $vpf_make['models'];
					foreach ( $vpf_models as $vpf_model ) {
						$model_name = $vpf_model['term']->name;
					
						if ( isset ( $vpf_model['years'] ) && ! empty ( $vpf_model['years'] ) ) {
							$vpf_years = $vpf_model['years'];
							foreach ( $vpf_years as $vpf_year ) {
								$year_name = $vpf_year['term']->name;
							
								if ( isset( $vpf_year['engines'] ) && ! empty ( $vpf_year['engines'] ) ) {
									$vpf_engines = $vpf_year['engines'];
									foreach ( $vpf_engines as $vpf_engine ) {
										$engine_name = $vpf_engine['term']->name;
										
										$terms[$i]['make']		= $make_name;
										$terms[$i]['model']		= $model_name;
										$terms[$i]['year']		= $year_name;
										$terms[$i]['engine']	= $engine_name;
										
										$i++;
									}
								} else {
									$terms[$i]['make']		= $make_name;
									$terms[$i]['model']		= $model_name;
									$terms[$i]['year']		= $year_name;
									$terms[$i]['engine']	= '';
									
									$i++;
								}
							}
						} else {
							$terms[$i]['make']		= $make_name;
							$terms[$i]['model']		= $model_name;
							$terms[$i]['year']		= '';
							$terms[$i]['engine']	= '';
							
							$i++;
						}
					}
				} else {
					$terms[$i]['make']		= $make_name;
					$terms[$i]['model']		= '';
					$terms[$i]['year']		= '';
					$terms[$i]['engine']	= '';
					
					$i++;
				}
			}
											
			if ( ! empty ( $terms ) ) {
				$woo_vpf_activate_tab_engines		= WC_Admin_Settings::get_option ( 'woo_vpf_activate_tab_engines' );
				
				$woo_vpf_activate_tab_year_ranges	= WC_Admin_Settings::get_option ( 'woo_vpf_activate_tab_year_ranges' );
				if ( $woo_vpf_activate_tab_year_ranges == 'yes' ) {
					$terms = WOO_VPF_Functions::arrange_terms_by_year_range ( $terms );
				}
				
				$terms = WOO_VPF_Functions::sort_terms ( $terms );
				$terms = apply_filters ( 'woo_vpf_sorted_tab_terms', $terms );
				
				foreach ( $terms as $term ) {
					?><tr>
						<td><?php echo $term['make']; ?></td>
						<td><?php echo $term['model']; ?></td>
						<td><?php echo $term['year']; ?></td>
						
						<?php
							if ( $woo_vpf_activate_tab_engines == 'yes' ) {
								?><td><?php echo $term['engine']; ?></td><?php
							}
						?>
					</tr><?php
				}
			}
		}
	}
	
	/**
	 * Delete All Terms
	 */
	public static function delete_all_terms () {
		global $wpdb;
		$wpdb->query( "DELETE wtt, wt, wtr FROM `".$wpdb->prefix."term_taxonomy` wtt LEFT JOIN `".$wpdb->prefix."terms` wt ON wtt.`term_id`=wt.`term_id` LEFT JOIN `".$wpdb->prefix."term_relationships` wtr ON wtt.`term_taxonomy_id`=wtr.`term_taxonomy_id` WHERE wtt.`taxonomy`='product_make'");
		
		return true;
	}
	
	/**
	 * Delete All Terms
	 */
	public static function get_levels () {
		$levels			= array (
			'make'		=> 'Make',
			'model'		=> 'Model',
			'year'		=> 'Year',
			'engine'	=> 'Engine',
			'sku'		=> 'SKU'
		);
		
		return apply_filters( 'woo_vpf_levels', $levels );
	}
}
