<?php
/**
 * Main WOO_VPF_Ajax Class
 *
 * @class WOO_VPF_Ajax
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WOO_VPF_Ajax {

	/**
	 * Hook in ajax handlers
	 */
	public static function init() {
		self::add_ajax_events();
	}
	
	/**
	 * Hook in methods - uses WordPress ajax handlers (admin-ajax)
	 */
	public static function add_ajax_events() {
		// WOO_VPF_EVENT => nopriv
		$ajax_events = array(
			'get_terms'				=> true,
			'reset_search'			=> true,
			'get_product_tab_terms'	=> true
		);

		foreach ( $ajax_events as $ajax_event => $nopriv ) {
			add_action( 'wp_ajax_woo_vpf_' . $ajax_event, array( __CLASS__, $ajax_event ) );

			if ( $nopriv ) {
				add_action( 'wp_ajax_nopriv_woo_vpf_' . $ajax_event, array( __CLASS__, $ajax_event ) );
			}
		}
	}
	
	/**
	 * AJAX - Get Terms
	 */
	public static function get_terms() {
		if( isset($_REQUEST['parent']) && $_REQUEST['parent'] > 0 ) {
			ob_start();
			
			$panel = '';
			if( isset ( $_REQUEST['panel'] ) ) {
				$panel = $_REQUEST['panel'];
			}
			
			WOO_VPF_Functions::get_terms_list( $_REQUEST['parent'], '', $panel );
			echo ob_get_clean();
		}

		die();
	}
	
	/**
	 * AJAX - Clear/Reset User Search if Rememberd
	 */
	public static function reset_search() {
		vpf_set_cookie ( 'search', '' );

		die();
	}
	
	/**
	 * AJAX - Get Product Tab Terms
	 */
	public static function get_product_tab_terms () {
		if ( isset ( $_REQUEST['post_id'] ) ) {
			WOO_VPF_Functions::get_product_tab_terms_list_table_rows ( $_REQUEST['post_id'] );
		}
		
		die ();
	}
}

WOO_VPF_Ajax::init();