<?php defined ( 'ABSPATH' ) || exit; ?>

<form class="wc-progress-form-content woocommerce-importer" method="post" action="<?php echo esc_url ( $this->get_next_step_link() ); ?>">
	<header>
		<h2><?php esc_html_e( 'Map CSV fields to terms', WOO_VPF_TEXT_DOMAIN ); ?></h2>
		<p><?php esc_html_e( 'Select fields from your CSV file to map against terms fields, or to ignore during import.', WOO_VPF_TEXT_DOMAIN ); ?></p>
	</header>
	
	<section class="wc-importer-mapping-table-wrapper">
		<table class="widefat wc-importer-mapping-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Column name', WOO_VPF_TEXT_DOMAIN ); ?></th>
					<th><?php esc_html_e( 'Map to field', WOO_VPF_TEXT_DOMAIN ); ?></th>
				</tr>
			</thead>
			
			<tbody>
				<?php
					foreach ( $headers as $index => $name ) :
						$mapped_value = $mapped_items[ $index ];
						?><tr>
							<td class="wc-importer-mapping-table-name">
								<?php echo esc_html( $name ); ?>
								<?php if ( ! empty( $sample[ $index ] ) ) : ?>
									<span class="description"><?php esc_html_e( 'Sample:', WOO_VPF_TEXT_DOMAIN ); ?> <code><?php echo esc_html( $sample[ $index ] ); ?></code></span>
								<?php endif; ?>
							</td>
							
							<td class="wc-importer-mapping-table-field">
								<input type="hidden" name="map_from[<?php echo esc_attr( $index ); ?>]" value="<?php echo esc_attr( $name ); ?>" />
								<select name="map_to[<?php echo esc_attr( $index ); ?>]">
									<option value=""><?php esc_html_e( 'Do not import', WOO_VPF_TEXT_DOMAIN ); ?></option>
									<option value="">--------------</option>
									<?php foreach ( $this->get_mapping_options () as $key => $value ) : ?>
										<option value="<?php echo esc_attr( $key ); ?>" <?php selected ( $mapped_value, $key ); ?>><?php echo esc_html( $value ); ?></option>
									<?php endforeach ?>
								</select>
							</td>
						</tr><?php
					endforeach;
				?>
			</tbody>
		</table>
	</section>
	
	<div class="wc-actions">
		<button type="submit" class="button button-primary button-next" value="<?php esc_attr_e( 'Run the importer', WOO_VPF_TEXT_DOMAIN ); ?>" name="save_step"><?php esc_html_e( 'Run the importer', WOO_VPF_TEXT_DOMAIN ); ?></button>
		<input type="hidden" name="file" value="<?php echo esc_attr( $this->file ); ?>" />
		<input type="hidden" name="delimiter" value="<?php echo esc_attr( $this->delimiter ); ?>" />
		<input type="hidden" name="delete_existing" value="<?php echo (int) $this->delete_existing; ?>" />
		<?php wp_nonce_field ( 'woo-vpf-csv-importer' ); ?>
	</div>
</form>
