<?php defined ( 'ABSPATH' ) || exit; ?>

<form class="wc-progress-form-content woocommerce-importer" enctype="multipart/form-data" method="post">
	<header>
		<h2><?php esc_html_e( 'Import terms from a CSV file', WOO_VPF_TEXT_DOMAIN ); ?></h2>
		<p>
			<?php esc_html_e( 'This tool allows you to import terms to your store from a CSV file.', WOO_VPF_TEXT_DOMAIN ); ?><br />
			<a href="<?php echo WOO_VPF_PLUGIN_URL; ?>/dummy-data/sample_terms.csv"><?php esc_html_e( 'Click here to download a sample CSV file', WOO_VPF_TEXT_DOMAIN ); ?></a>
		</p>
	</header>
	
	<section>
		<table class="form-table woocommerce-importer-options">
			<tbody>
				<tr>
					<th scope="row">
						<label for="upload">
							<?php esc_html_e( 'Choose a CSV file from your computer:', WOO_VPF_TEXT_DOMAIN ); ?>
						</label>
					</th>
					
					<td>
						<?php if ( ! empty ( $upload_dir['error'] ) ) { ?>
							<div class="inline error">
								<p><?php esc_html_e( 'Before you can upload your import file, you will need to fix the following error:', WOO_VPF_TEXT_DOMAIN ); ?></p>
								<p><strong><?php echo esc_html( $upload_dir['error'] ); ?></strong></p>
							</div>
						<?php } else { ?>
							<input type="file" id="upload" name="import" size="25" />
							<input type="hidden" name="action" value="save" />
							<input type="hidden" name="max_file_size" value="<?php echo esc_attr( $bytes ); ?>" />
							<br/><small><?php printf ( esc_html__( 'Maximum size: %s', WOO_VPF_TEXT_DOMAIN ), esc_html( $size ) ); ?></small>
						<?php } ?>
					</td>
				</tr>
				
				<tr>
					<th><label for="woocommerce-importer-delete-existing"><?php esc_html_e( 'Delete existing terms', WOO_VPF_TEXT_DOMAIN ); ?></label></th>
					<td>
						<input type="hidden" name="delete_existing" value="0" />
						<input type="checkbox" id="woocommerce-importer-delete-existing" name="delete_existing" value="1" />
						<label for="woocommerce-importer-delete-existing"><?php esc_html_e( 'All the existing terms will be deleted before importing new terms.', WOO_VPF_TEXT_DOMAIN ); ?></label>
					</td>
				</tr>
				
				<tr>
					<th><label for="woocommerce-importer-product-column"><?php esc_html_e( 'Product matching column', WOO_VPF_TEXT_DOMAIN ); ?></label><br/></th>
					<td>
						<select name="product_column">
							<option value="sku" selected><?php _e( 'SKU', WOO_VPF_TEXT_DOMAIN ); ?></option>
							<option value="slug"><?php _e( 'Slug', WOO_VPF_TEXT_DOMAIN ); ?></option>
						</select>
					</td>
				</tr>
				
				<tr class="woocommerce-importer-advanced hidden">
					<th>
						<label for="woocommerce-importer-file-url"><?php esc_html_e( 'Alternatively, enter the path to a CSV file on your server:', WOO_VPF_TEXT_DOMAIN ); ?></label>
					</th>
					<td>
						<label for="woocommerce-importer-file-url" class="woocommerce-importer-file-url-field-wrapper">
							<code><?php echo esc_html( ABSPATH ) . ' '; ?></code><input type="text" id="woocommerce-importer-file-url" name="file_url" />
						</label>
					</td>
				</tr>
				
				<tr class="woocommerce-importer-advanced hidden">
					<th><label><?php esc_html_e( 'CSV Delimiter', WOO_VPF_TEXT_DOMAIN ); ?></label><br/></th>
					<td><input type="text" name="delimiter" placeholder="," size="2" /></td>
				</tr>
			</tbody>
		</table>
	</section>
	
	<script type="text/javascript">
		jQuery(function($) {
			$( '.woocommerce-importer-toggle-advanced-options' ).on( 'click', function() {
				var elements = $( '.woocommerce-importer-advanced' );
				if ( elements.is( '.hidden' ) ) {
					elements.removeClass( 'hidden' );
					$( this ).text( $( this ).data( 'hidetext' ) );
				} else {
					elements.addClass( 'hidden' );
					$( this ).text( $( this ).data( 'showtext' ) );
				}
				return false;
			} );
		});
	</script>
	
	<div class="wc-actions">
		<a href="#" class="woocommerce-importer-toggle-advanced-options" data-hidetext="<?php esc_html_e( 'Hide advanced options', WOO_VPF_TEXT_DOMAIN ); ?>" data-showtext="<?php esc_html_e( 'Hide advanced options', WOO_VPF_TEXT_DOMAIN ); ?>"><?php esc_html_e( 'Show advanced options', WOO_VPF_TEXT_DOMAIN ); ?></a>
		
		<button type="submit" class="button button-primary button-next" value="<?php esc_attr_e( 'Continue', WOO_VPF_TEXT_DOMAIN ); ?>" name="save_step"><?php esc_html_e( 'Continue', WOO_VPF_TEXT_DOMAIN ); ?></button>
		<?php wp_nonce_field ( 'woo-vpf-csv-importer' ); ?>
	</div>
</form>
