<?php defined ( 'ABSPATH' ) || exit; ?>

<div class="wc-progress-form-content woocommerce-importer">
	<section class="woocommerce-importer-done">
		<?php
			$results = array();

			if ( 0 < $imported ) {
				$results[] = sprintf(
					_n( '%s rows imported', '%s rows imported', $imported, WOO_VPF_TEXT_DOMAIN ),
					'<strong>' . number_format_i18n ( $imported ) . '</strong>'
				);
			}

			if ( 0 < $skipped ) {
				$results[] = sprintf(
					_n( '%s term was skipped', '%s terms were skipped', $skipped, WOO_VPF_TEXT_DOMAIN ),
					'<strong>' . number_format_i18n ( $skipped ) . '</strong>'
				);
			}

			if ( 0 < $failed ) {
				$results [] = sprintf(
					_n( 'Failed to import %s term', 'Failed to import %s terms', $failed, WOO_VPF_TEXT_DOMAIN ),
					'<strong>' . number_format_i18n ( $failed ) . '</strong>'
				);
			}

			if ( 0 < $failed || 0 < $skipped ) {
				$results[] = '<a href="#" class="woocommerce-importer-done-view-errors">' . __( 'View import log', WOO_VPF_TEXT_DOMAIN ) . '</a>';
			}

			echo wp_kses_post ( __( 'Import complete!', WOO_VPF_TEXT_DOMAIN ) . ' ' . implode ( '. ', $results ) );
		?>
	</section>
	
	<section class="wc-importer-error-log" style="display:none">
		<table class="widefat wc-importer-error-log-table">
			<thead>
				<tr>
					<th><?php esc_html_e ( 'Term', WOO_VPF_TEXT_DOMAIN ); ?></th>
					<th><?php esc_html_e ( 'Reason for failure', WOO_VPF_TEXT_DOMAIN ); ?></th>
				</tr>
			</thead>
			
			<tbody>
				<?php
				if ( count( $errors ) ) {
					foreach ( $errors as $error ) {
						if ( ! is_wp_error( $error ) ) {
							continue;
						}
						$error_data = $error->get_error_data();
						?><tr>
							<th><code><?php echo esc_html ( $error_data['row'] ); ?></code></th>
							<td><?php echo esc_html ( $error->get_error_message () ); ?></td>
						</tr><?php
					}
				}
				?>
			</tbody>
		</table>
	</section>
	
	<script type="text/javascript">
		jQuery(function() {
			jQuery( '.woocommerce-importer-done-view-errors' ).on( 'click', function() {
				jQuery( '.wc-importer-error-log' ).slideToggle();
				return false;
			} );
		} );
	</script>
	
	<div class="wc-actions">
		<a class="button button-primary" href="<?php echo esc_url ( admin_url ( 'edit-tags.php?taxonomy=product_make&post_type=product' ) ); ?>"><?php esc_html_e ( 'View Terms', WOO_VPF_TEXT_DOMAIN ); ?></a>
	</div>
</div>
